/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.tiles;

import com.google.common.base.Preconditions;
import forestry.api.core.IErrorLogic;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IStamps;
import forestry.api.mail.PostManager;
import forestry.core.errors.EnumErrorCode;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.PacketBufferForestry;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import forestry.core.tiles.TileBase;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.NetworkUtil;
import forestry.mail.MailAddress;
import forestry.mail.TradeStation;
import forestry.mail.features.MailTiles;
import forestry.mail.gui.ContainerTradeName;
import forestry.mail.gui.ContainerTrader;
import forestry.mail.inventory.InventoryTradeStation;
import forestry.mail.network.packets.PacketTraderAddressResponse;
import java.io.IOException;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileTrader
extends TileBase
implements IOwnedTile {
    private final OwnerHandler ownerHandler = new OwnerHandler();
    private IMailAddress address = new MailAddress();

    public TileTrader() {
        super(MailTiles.TRADER.tileType());
        this.setInternalInventory(new InventoryTradeStation());
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }

    @Override
    public void onRemoval() {
        if (this.isLinked() && !this.field_145850_b.field_72995_K) {
            PostManager.postRegistry.deleteTradeStation((ServerWorld)this.field_145850_b, this.address);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        CompoundNBT nbt = new CompoundNBT();
        this.address.write(nbt);
        compoundNBT.func_218657_a("address", (INBT)nbt);
        this.ownerHandler.write(compoundNBT);
        return compoundNBT;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        if (compoundNBT.func_74764_b("address")) {
            this.address = new MailAddress(compoundNBT.func_74775_l("address"));
        }
        this.ownerHandler.read(compoundNBT);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        this.ownerHandler.writeData(data);
        String addressName = this.address.getName();
        data.func_180714_a(addressName);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.ownerHandler.readData(data);
        String addressName = data.func_218666_n();
        if (!addressName.isEmpty()) {
            this.address = PostManager.postRegistry.getMailAddress(addressName);
        }
    }

    @Override
    public void updateServerSide() {
        if (!this.isLinked() || !this.updateOnInterval(10)) {
            return;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!this.hasPostageMin(3), EnumErrorCode.NO_STAMPS);
        errorLogic.setCondition(!this.hasPaperMin(2), EnumErrorCode.NO_PAPER);
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack tradeGood = inventory.func_70301_a(0);
        errorLogic.setCondition(tradeGood.func_190926_b(), EnumErrorCode.NO_TRADE);
        boolean hasRequest = this.hasItemCount(1, 4, ItemStack.field_190927_a, 1);
        errorLogic.setCondition(!hasRequest, EnumErrorCode.NO_TRADE);
        if (!tradeGood.func_190926_b()) {
            boolean hasSupplies = this.hasItemCount(30, 10, tradeGood, tradeGood.func_190916_E());
            errorLogic.setCondition(!hasSupplies, EnumErrorCode.NO_SUPPLIES);
        }
        if (inventory instanceof TradeStation && this.updateOnInterval(200)) {
            boolean canReceivePayment = ((TradeStation)inventory).canReceivePayment();
            errorLogic.setCondition(!canReceivePayment, EnumErrorCode.NO_SPACE_INVENTORY);
        }
    }

    public boolean isLinked() {
        if (!this.address.isValid()) {
            return false;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        return !errorLogic.contains(EnumErrorCode.NOT_ALPHANUMERIC) && !errorLogic.contains(EnumErrorCode.NOT_UNIQUE);
    }

    private boolean hasItemCount(int startSlot, int countSlots, ItemStack item, int itemCount) {
        int count = 0;
        IInventoryAdapter tradeInventory = this.getInternalInventory();
        for (int i = startSlot; i < startSlot + countSlots; ++i) {
            ItemStack itemInSlot = tradeInventory.func_70301_a(i);
            if (itemInSlot.func_190926_b()) continue;
            if (item.func_190926_b() || ItemStackUtil.isIdenticalItem(itemInSlot, item)) {
                count += itemInSlot.func_190916_E();
            }
            if (count < itemCount) continue;
            return true;
        }
        return false;
    }

    private float percentOccupied(int startSlot, int countSlots, ItemStack item) {
        int count = 0;
        int total = 0;
        IInventoryAdapter tradeInventory = this.getInternalInventory();
        for (int i = startSlot; i < startSlot + countSlots; ++i) {
            ItemStack itemInSlot = tradeInventory.func_70301_a(i);
            if (itemInSlot.func_190926_b()) {
                total += tradeInventory.func_70297_j_();
                continue;
            }
            total += itemInSlot.func_77976_d();
            if (!item.func_190926_b() && !ItemStackUtil.isIdenticalItem(itemInSlot, item)) continue;
            count += itemInSlot.func_190916_E();
        }
        return (float)count / (float)total;
    }

    public boolean hasPaperMin(int count) {
        return this.hasItemCount(5, 6, new ItemStack((IItemProvider)Items.field_151121_aF), count);
    }

    public boolean hasPostageMin(int postage) {
        int posted = 0;
        IInventoryAdapter tradeInventory = this.getInternalInventory();
        for (int i = 11; i < 15; ++i) {
            ItemStack stamp = tradeInventory.func_70301_a(i);
            if (stamp.func_190926_b() || !(stamp.func_77973_b() instanceof IStamps) || (posted += ((IStamps)stamp.func_77973_b()).getPostage(stamp).getValue() * stamp.func_190916_E()) < postage) continue;
            return true;
        }
        return false;
    }

    public IMailAddress getAddress() {
        return this.address;
    }

    public void handleSetAddressRequest(String addressName) {
        IMailAddress address = PostManager.postRegistry.getMailAddress(addressName);
        this.setAddress(address);
        IMailAddress newAddress = this.getAddress();
        String newAddressName = newAddress.getName();
        if (newAddressName.equals(addressName)) {
            PacketTraderAddressResponse packetResponse = new PacketTraderAddressResponse(this, addressName);
            NetworkUtil.sendNetworkPacket(packetResponse, this.field_174879_c, this.field_145850_b);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleSetAddressResponse(String addressName) {
        IMailAddress address = PostManager.postRegistry.getMailAddress(addressName);
        this.setAddress(address);
    }

    private void setAddress(IMailAddress address) {
        Preconditions.checkNotNull((Object)address, (Object)"address must not be null");
        if (this.address.isValid() && this.address.equals(address)) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            ServerWorld world = (ServerWorld)this.field_145850_b;
            IErrorLogic errorLogic = this.getErrorLogic();
            boolean hasValidTradeAddress = PostManager.postRegistry.isValidTradeAddress((World)world, address);
            errorLogic.setCondition(!hasValidTradeAddress, EnumErrorCode.NOT_ALPHANUMERIC);
            boolean hasUniqueTradeAddress = PostManager.postRegistry.isAvailableTradeAddress(world, address);
            errorLogic.setCondition(!hasUniqueTradeAddress, EnumErrorCode.NOT_UNIQUE);
            if (hasValidTradeAddress & hasUniqueTradeAddress) {
                this.address = address;
                PostManager.postRegistry.getOrCreateTradeStation(world, this.getOwnerHandler().getOwner(), address);
            }
        } else {
            this.address = address;
        }
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        if (this.field_145850_b.field_72995_K || !this.address.isValid()) {
            return super.getInternalInventory();
        }
        return (TradeStation)PostManager.postRegistry.getOrCreateTradeStation((ServerWorld)this.field_145850_b, this.getOwnerHandler().getOwner(), this.address);
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        if (this.isLinked()) {
            return new ContainerTrader(windowId, inv, this);
        }
        return new ContainerTradeName(windowId, inv, this);
    }
}

