/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostalState;
import forestry.api.mail.PostManager;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.tiles.TileBase;
import forestry.mail.EnumDeliveryState;
import forestry.mail.PostRegistry;
import forestry.mail.features.MailTiles;
import forestry.mail.gui.ContainerMailbox;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TileMailbox
extends TileBase {
    public TileMailbox() {
        super(MailTiles.MAILBOX.tileType());
        this.setInternalInventory(new InventoryAdapter(84, "Letters").disableAutomation());
    }

    @Override
    public void openGui(ServerPlayerEntity player, BlockPos pos) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack heldItem = player.func_184586_b(player.func_184600_cs());
        if (PostManager.postRegistry.isLetter(heldItem)) {
            IPostalState result = this.tryDispatchLetter(heldItem);
            if (!result.isOk()) {
                player.func_145747_a(result.getDescription(), Util.field_240973_b_);
            } else {
                heldItem.func_190918_g(1);
            }
        } else {
            super.openGui(player, pos);
        }
    }

    public IInventory getOrCreateMailInventory(World world, GameProfile playerProfile) {
        if (world.field_72995_K) {
            return this.getInternalInventory();
        }
        IMailAddress address = PostManager.postRegistry.getMailAddress(playerProfile);
        return PostRegistry.getOrCreatePOBox((ServerWorld)world, address);
    }

    private IPostalState tryDispatchLetter(ItemStack letterStack) {
        IPostalState result;
        ILetter letter = PostManager.postRegistry.getLetter(letterStack);
        if (letter != null) {
            ServerWorld world = (ServerWorld)this.field_145850_b;
            result = PostManager.postRegistry.getPostOffice(world).lodgeLetter(world, letterStack, true);
        } else {
            result = EnumDeliveryState.NOT_MAILABLE;
        }
        return result;
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerMailbox(windowId, inv, this);
    }
}

