/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.items;

import forestry.api.core.IItemSubtype;
import forestry.core.ItemGroupForestry;
import forestry.core.items.ItemWithGui;
import forestry.mail.Letter;
import forestry.mail.gui.ContainerLetter;
import forestry.mail.inventory.ItemInventoryLetter;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemLetter
extends ItemWithGui {
    private Size size;
    private State state;

    public ItemLetter(Size size, State state) {
        super(new Item.Properties().func_200916_a(ItemGroupForestry.tabForestry).func_200917_a(64));
        this.size = size;
        this.state = state;
    }

    public Size getSize() {
        return this.size;
    }

    public State getState() {
        return this.state;
    }

    public String func_77658_a() {
        return "item.forestry.letter";
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        if (heldItem.func_190916_E() == 1) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("for.chat.mail.wrongstacksize"), Util.field_240973_b_);
        return ActionResult.func_226251_d_((Object)heldItem);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemstack, world, list, flag);
        CompoundNBT compoundNBT = itemstack.func_77978_p();
        if (compoundNBT == null) {
            list.add((ITextComponent)new StringTextComponent("<").func_230529_a_((ITextComponent)new TranslationTextComponent("for.gui.blank").func_240702_b_(">")).func_240699_a_(TextFormatting.GRAY));
            return;
        }
        Letter letter = new Letter(compoundNBT);
        letter.addTooltip(list);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(group) && this.state == State.FRESH && this.size == Size.EMPTY) {
            stacks.add((Object)new ItemStack((IItemProvider)this));
        }
    }

    @Override
    @Nullable
    public Container getContainer(int windowId, PlayerEntity player, ItemStack heldItem) {
        return new ContainerLetter(windowId, player, new ItemInventoryLetter(player, heldItem));
    }

    public static enum Size implements IItemSubtype
    {
        EMPTY,
        SMALL,
        BIG;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum State implements IItemSubtype
    {
        FRESH,
        STAMPED,
        OPENED,
        EMPTIED;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

