/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.core.config.Config;
import forestry.core.render.ForestryResource;
import forestry.core.utils.SoundUtil;
import forestry.mail.POBoxInfo;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuiMailboxInfo
extends AbstractGui {
    public static final GuiMailboxInfo instance = new GuiMailboxInfo();
    private static final int WIDTH = 98;
    private static final int HEIGHT = 17;
    private final FontRenderer fontRenderer;
    @Nullable
    private POBoxInfo poInfo;
    private final ResourceLocation textureAlert = new ForestryResource("textures/gui/mailalert.png");

    private GuiMailboxInfo() {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
    }

    public void render(MatrixStack transform) {
        if (this.poInfo == null || !Config.mailAlertEnabled || !this.poInfo.hasMail()) {
            return;
        }
        int x = 0;
        int y = 0;
        Minecraft minecraft = Minecraft.func_71410_x();
        MainWindow win = minecraft.func_228018_at_();
        if (Config.mailAlertXPosition == XPosition.RIGHT) {
            x = win.func_198107_o() - 98;
        }
        if (Config.mailAlertYPosition == YPosition.BOTTOM) {
            y = win.func_198087_p() - 17;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableLighting();
        TextureManager textureManager = minecraft.func_110434_K();
        textureManager.func_110577_a(this.textureAlert);
        this.func_238474_b_(transform, x, y, 0, 0, 98, 17);
        this.fontRenderer.func_238421_b_(transform, Integer.toString(this.poInfo.playerLetters), (float)(x + 27 + this.getCenteredOffset(Integer.toString(this.poInfo.playerLetters), 22)), (float)(y + 5), 0xFFFFFF);
        this.fontRenderer.func_238421_b_(transform, Integer.toString(this.poInfo.tradeLetters), (float)(x + 75 + this.getCenteredOffset(Integer.toString(this.poInfo.tradeLetters), 22)), (float)(y + 5), 0xFFFFFF);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.fontRenderer.func_78256_a(string)) / 2;
    }

    public boolean hasPOBoxInfo() {
        return this.poInfo != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setPOBoxInfo(PlayerEntity player, POBoxInfo info) {
        boolean playJingle = false;
        if (info.hasMail()) {
            if (this.poInfo == null) {
                playJingle = true;
            } else if (this.poInfo.playerLetters != info.playerLetters || this.poInfo.tradeLetters != info.tradeLetters) {
                playJingle = true;
            }
        }
        if (playJingle) {
            SoundUtil.playSoundEvent(SoundEvents.field_187802_ec);
        }
        this.poInfo = info;
    }

    public static enum YPosition {
        TOP,
        BOTTOM;

    }

    public static enum XPosition {
        LEFT,
        RIGHT;

    }
}

