/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.core.tooltips.ToolTip;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.PostManager;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.render.TextureManagerForestry;
import forestry.core.utils.SoundUtil;
import forestry.mail.gui.ContainerLetter;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class AddresseeSlot
extends Widget {
    private final ContainerLetter containerLetter;

    public AddresseeSlot(WidgetManager widgetManager, int xPos, int yPos, ContainerLetter containerLetter) {
        super(widgetManager, xPos, yPos);
        this.containerLetter = containerLetter;
        this.width = 26;
        this.height = 15;
    }

    @Override
    public void draw(MatrixStack transform, int startY, int startX) {
        IPostalCarrier carrier = PostManager.postRegistry.getCarrier(this.containerLetter.getCarrierType());
        if (carrier != null) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureManagerForestry.getInstance().bindGuiTextureMap();
            AbstractGui.func_238470_a_((MatrixStack)transform, (int)(startX + this.xPos), (int)(startY + this.yPos), (int)this.manager.gui.func_230927_p_(), (int)32, (int)32, (TextureAtlasSprite)carrier.getSprite());
        }
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        ToolTip tooltip = new ToolTip();
        tooltip.translated("for.gui.addressee." + (Object)((Object)this.containerLetter.getCarrierType()), new Object[0]);
        return tooltip;
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        if (!this.containerLetter.getLetter().isProcessed()) {
            this.containerLetter.advanceCarrierType();
            SoundUtil.playButtonClick();
        }
    }
}

