/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostOffice;
import forestry.api.mail.IPostRegistry;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.PostManager;
import forestry.core.utils.Log;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.PlayerUtil;
import forestry.mail.Letter;
import forestry.mail.LetterProperties;
import forestry.mail.MailAddress;
import forestry.mail.POBox;
import forestry.mail.PostOffice;
import forestry.mail.TradeStation;
import forestry.mail.features.MailItems;
import forestry.mail.network.packets.PacketPOBoxInfoResponse;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PostRegistry
implements IPostRegistry {
    @Nullable
    public static PostOffice cachedPostOffice;
    public static final Map<IMailAddress, POBox> cachedPOBoxes;
    public static final Map<IMailAddress, ITradeStation> cachedTradeStations;
    private final Map<EnumAddressee, IPostalCarrier> carriers = new EnumMap<EnumAddressee, IPostalCarrier>(EnumAddressee.class);

    @Override
    public boolean isValidPOBox(World world, IMailAddress address) {
        return address.getType() == EnumAddressee.PLAYER && address.getName().matches("^[a-zA-Z0-9]+$");
    }

    @Nullable
    public static POBox getPOBox(ServerWorld world, IMailAddress address) {
        if (cachedPOBoxes.containsKey(address)) {
            return cachedPOBoxes.get(address);
        }
        POBox pobox = (POBox)world.func_217481_x().func_215753_b(() -> new POBox(address), "pobox_" + address);
        if (pobox != null) {
            cachedPOBoxes.put(address, pobox);
        }
        return pobox;
    }

    public static POBox getOrCreatePOBox(ServerWorld world, IMailAddress add) {
        POBox pobox = PostRegistry.getPOBox(world, add);
        if (pobox == null) {
            pobox = (POBox)world.func_217481_x().func_215752_a(() -> new POBox(add), "pobox_" + add);
            pobox.func_76185_a();
            cachedPOBoxes.put(add, pobox);
            PlayerEntity player = PlayerUtil.getPlayer((World)world, add.getPlayerProfile());
            if (player != null) {
                NetworkUtil.sendToPlayer(new PacketPOBoxInfoResponse(pobox.getPOBoxInfo()), player);
            }
        }
        return pobox;
    }

    @Override
    public boolean isValidTradeAddress(World world, IMailAddress address) {
        return address.getType() == EnumAddressee.TRADER && address.getName().matches("^[a-zA-Z0-9]+$");
    }

    @Override
    public boolean isAvailableTradeAddress(ServerWorld world, IMailAddress address) {
        return this.getTradeStation(world, address) == null;
    }

    @Override
    public TradeStation getTradeStation(ServerWorld world, IMailAddress address) {
        if (cachedTradeStations.containsKey(address)) {
            return (TradeStation)cachedTradeStations.get(address);
        }
        TradeStation trade = (TradeStation)world.func_217481_x().func_215753_b(() -> new TradeStation("trade_po_" + address), "trade_po_" + address);
        if (trade != null && trade.isValid()) {
            cachedTradeStations.put(address, trade);
            this.getPostOffice(world).registerTradeStation(trade);
            return trade;
        }
        return null;
    }

    @Override
    public TradeStation getOrCreateTradeStation(ServerWorld world, GameProfile owner, IMailAddress address) {
        TradeStation trade = this.getTradeStation(world, address);
        if (trade == null) {
            trade = (TradeStation)world.func_217481_x().func_215752_a(() -> new TradeStation(owner, address), "trade_po_" + address);
            trade.func_76185_a();
            cachedTradeStations.put(address, trade);
            this.getPostOffice(world).registerTradeStation(trade);
        }
        return trade;
    }

    @Override
    public void deleteTradeStation(ServerWorld world, IMailAddress address) {
        TradeStation trade = this.getTradeStation(world, address);
        if (trade == null) {
            return;
        }
        trade.invalidate();
        cachedTradeStations.remove(address);
        this.getPostOffice(world).deregisterTradeStation(trade);
        boolean delete = false;
        if (!delete) {
            Log.error("Failed to delete trade station file. {}", "FIXME!");
        }
    }

    @Override
    public IPostOffice getPostOffice(ServerWorld world) {
        if (cachedPostOffice != null) {
            return cachedPostOffice;
        }
        PostOffice office = (PostOffice)world.func_217481_x().func_215752_a(PostOffice::new, "forestry_mail");
        office.setWorld(world);
        cachedPostOffice = office;
        return office;
    }

    @Override
    public IMailAddress getMailAddress(GameProfile gameProfile) {
        return new MailAddress(gameProfile);
    }

    @Override
    public IMailAddress getMailAddress(String traderName) {
        return new MailAddress(traderName);
    }

    @Override
    public Map<EnumAddressee, IPostalCarrier> getRegisteredCarriers() {
        return this.carriers;
    }

    @Override
    public void registerCarrier(IPostalCarrier carrier) {
        this.carriers.put(carrier.getType(), carrier);
    }

    @Override
    public IPostalCarrier getCarrier(EnumAddressee type) {
        return this.carriers.get((Object)type);
    }

    @Override
    public ILetter createLetter(IMailAddress sender, IMailAddress recipient) {
        return new Letter(sender, recipient);
    }

    @Override
    public ItemStack createLetterStack(ILetter letter) {
        CompoundNBT compoundNBT = new CompoundNBT();
        letter.write(compoundNBT);
        ItemStack letterStack = LetterProperties.createStampedLetterStack(letter);
        letterStack.func_77982_d(compoundNBT);
        return letterStack;
    }

    @Override
    @Nullable
    public ILetter getLetter(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return null;
        }
        if (!PostManager.postRegistry.isLetter(itemstack)) {
            return null;
        }
        if (itemstack.func_77978_p() == null) {
            return null;
        }
        return new Letter(itemstack.func_77978_p());
    }

    @Override
    public boolean isLetter(ItemStack itemstack) {
        return MailItems.LETTERS.itemEqual(itemstack);
    }

    static {
        cachedPOBoxes = new HashMap<IMailAddress, POBox>();
        cachedTradeStations = new HashMap<IMailAddress, ITradeStation>();
    }
}

