/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.mail.EnumPostage;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostOffice;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.IPostalState;
import forestry.api.mail.IStamps;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.PostManager;
import forestry.mail.EnumDeliveryState;
import forestry.mail.features.MailItems;
import forestry.mail.items.EnumStampDefinition;
import java.util.LinkedHashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class PostOffice
extends WorldSavedData
implements IPostOffice {
    public static final String SAVE_NAME = "forestry_mail";
    private final int[] collectedPostage = new int[EnumPostage.values().length];
    private LinkedHashMap<IMailAddress, ITradeStation> activeTradeStations = new LinkedHashMap();

    public PostOffice() {
        super(SAVE_NAME);
    }

    public PostOffice(String s) {
        super(s);
    }

    public void setWorld(ServerWorld world) {
        this.refreshActiveTradeStations(world);
    }

    public void func_76184_a(CompoundNBT compoundNBT) {
        for (int i = 0; i < this.collectedPostage.length; ++i) {
            if (!compoundNBT.func_74764_b("CPS" + i)) continue;
            this.collectedPostage[i] = compoundNBT.func_74762_e("CPS" + i);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compoundNBT) {
        for (int i = 0; i < this.collectedPostage.length; ++i) {
            compoundNBT.func_74768_a("CPS" + i, this.collectedPostage[i]);
        }
        return compoundNBT;
    }

    public LinkedHashMap<IMailAddress, ITradeStation> getActiveTradeStations(World world) {
        return this.activeTradeStations;
    }

    private void refreshActiveTradeStations(ServerWorld world) {
    }

    @Override
    public void registerTradeStation(ITradeStation trade) {
        if (!this.activeTradeStations.containsKey(trade.getAddress())) {
            this.activeTradeStations.put(trade.getAddress(), trade);
        }
    }

    @Override
    public void deregisterTradeStation(ITradeStation trade) {
        this.activeTradeStations.remove(trade.getAddress());
    }

    @Override
    public ItemStack getAnyStamp(int max) {
        return this.getAnyStamp(EnumPostage.values(), max);
    }

    @Override
    public ItemStack getAnyStamp(EnumPostage postage, int max) {
        return this.getAnyStamp(new EnumPostage[]{postage}, max);
    }

    @Override
    public ItemStack getAnyStamp(EnumPostage[] postages, int max) {
        for (EnumPostage postage : postages) {
            int collected = Math.min(max, this.collectedPostage[postage.ordinal()]);
            int n = postage.ordinal();
            this.collectedPostage[n] = this.collectedPostage[n] - collected;
            if (collected <= 0) continue;
            EnumStampDefinition stampDefinition = EnumStampDefinition.getFromPostage(postage);
            return MailItems.STAMPS.stack(stampDefinition, collected);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public IPostalState lodgeLetter(ServerWorld world, ItemStack itemstack, boolean doLodge) {
        IPostalCarrier carrier;
        ILetter letter = PostManager.postRegistry.getLetter(itemstack);
        if (letter == null) {
            return EnumDeliveryState.NOT_MAILABLE;
        }
        if (letter.isProcessed()) {
            return EnumDeliveryState.ALREADY_MAILED;
        }
        if (!letter.isPostPaid()) {
            return EnumDeliveryState.NOT_POSTPAID;
        }
        if (!letter.isMailable()) {
            return EnumDeliveryState.NOT_MAILABLE;
        }
        IPostalState state = EnumDeliveryState.NOT_MAILABLE;
        IMailAddress address = letter.getRecipient();
        if (address != null && (carrier = PostManager.postRegistry.getCarrier(address.getType())) != null) {
            state = carrier.deliverLetter(world, this, address, itemstack, doLodge);
        }
        if (!state.isOk()) {
            return state;
        }
        this.collectPostage(letter.getPostage());
        this.func_76185_a();
        return EnumDeliveryState.OK;
    }

    @Override
    public void collectPostage(NonNullList<ItemStack> stamps) {
        for (ItemStack stamp : stamps) {
            if (stamp == null || !(stamp.func_77973_b() instanceof IStamps)) continue;
            EnumPostage postage = ((IStamps)stamp.func_77973_b()).getPostage(stamp);
            int n = postage.ordinal();
            this.collectedPostage[n] = this.collectedPostage[n] + stamp.func_190916_E();
        }
    }
}

