/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.mail.EnumAddressee;
import forestry.api.mail.PostManager;
import forestry.api.modules.ForestryModule;
import forestry.core.ISaveEventHandler;
import forestry.core.ModuleCore;
import forestry.core.config.Config;
import forestry.core.network.IPacketRegistry;
import forestry.mail.EventHandlerMailAlert;
import forestry.mail.PostRegistry;
import forestry.mail.PostalCarrier;
import forestry.mail.SaveEventHandlerMail;
import forestry.mail.commands.CommandMail;
import forestry.mail.features.MailContainers;
import forestry.mail.gui.GuiCatalogue;
import forestry.mail.gui.GuiLetter;
import forestry.mail.gui.GuiMailbox;
import forestry.mail.gui.GuiStampCollector;
import forestry.mail.gui.GuiTradeName;
import forestry.mail.gui.GuiTrader;
import forestry.mail.network.PacketRegistryMail;
import forestry.modules.BlankForestryModule;
import net.minecraft.client.gui.ScreenManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;

@ForestryModule(containerID="forestry", moduleID="mail", name="Mail", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.mail.description")
public class ModuleMail
extends BlankForestryModule {
    @Override
    public void setupAPI() {
        PostManager.postRegistry = new PostRegistry();
        PostManager.postRegistry.registerCarrier(new PostalCarrier(EnumAddressee.PLAYER));
        PostManager.postRegistry.registerCarrier(new PostalCarrier(EnumAddressee.TRADER));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerGuiFactories() {
        ScreenManager.func_216911_a(MailContainers.CATALOGUE.containerType(), GuiCatalogue::new);
        ScreenManager.func_216911_a(MailContainers.LETTER.containerType(), GuiLetter::new);
        ScreenManager.func_216911_a(MailContainers.MAILBOX.containerType(), GuiMailbox::new);
        ScreenManager.func_216911_a(MailContainers.STAMP_COLLECTOR.containerType(), GuiStampCollector::new);
        ScreenManager.func_216911_a(MailContainers.TRADE_NAME.containerType(), GuiTradeName::new);
        ScreenManager.func_216911_a(MailContainers.TRADER.containerType(), GuiTrader::new);
    }

    @Override
    public void preInit() {
        ModuleCore.rootCommand.then(CommandMail.register());
        if (Config.mailAlertEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)new EventHandlerMailAlert());
        }
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryMail();
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerMail();
    }
}

