/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.render;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.api.lepidopterology.genetics.IAlleleButterflySpecies;
import forestry.core.models.AbstractBakedModel;
import forestry.core.models.TRSRBakedModel;
import forestry.core.utils.ResourceUtil;
import genetics.api.GeneticHelper;
import genetics.api.alleles.IAlleleValue;
import genetics.api.organism.IOrganism;
import genetics.utils.AlleleUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.client.model.geometry.IModelGeometry;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyItemModel
extends AbstractBakedModel {
    private final ImmutableMap<String, IBakedModel> subModels;
    private final Cache<Pair<String, Float>, IBakedModel> cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    public ButterflyItemModel(ImmutableMap<String, IBakedModel> subModels) {
        this.subModels = subModels;
    }

    @Override
    protected ItemOverrideList createOverrides() {
        return new OverrideList();
    }

    public static class Loader
    implements IModelLoader<Geometry> {
        public void func_195410_a(IResourceManager resourceManager) {
        }

        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            ImmutableMap.Builder subModels = new ImmutableMap.Builder();
            AlleleUtils.forEach(ButterflyChromosomes.SPECIES, butterfly -> {
                ResourceLocation registryName = butterfly.getRegistryName();
                subModels.put((Object)registryName.func_110623_a(), (Object)butterfly.getItemTexture().toString());
            });
            return new Geometry((ImmutableMap<String, String>)subModels.build());
        }
    }

    private static class Geometry
    implements IModelGeometry<Geometry> {
        public final ImmutableMap<String, String> subModels;

        public Geometry(ImmutableMap<String, String> subModels) {
            this.subModels = subModels;
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
            IUnbakedModel modelButterfly = bakery.func_209597_a(new ResourceLocation("forestry", "item/butterfly"));
            if (!(modelButterfly instanceof BlockModel)) {
                return null;
            }
            ImmutableMap.Builder subModelBuilder = new ImmutableMap.Builder();
            BlockModel modelBlock = (BlockModel)modelButterfly;
            for (Map.Entry subModel : this.subModels.entrySet()) {
                String identifier = (String)subModel.getKey();
                String texture = (String)subModel.getValue();
                BlockModel model = new BlockModel(modelBlock.getParentLocation(), modelBlock.func_178298_a(), (Map)ImmutableMap.of((Object)"butterfly", (Object)Either.left((Object)new RenderMaterial(PlayerContainer.field_226615_c_, new ResourceLocation(texture)))), modelBlock.field_178322_i, modelBlock.func_230176_c_(), modelBlock.func_181682_g(), modelBlock.func_187966_f());
                ResourceLocation location = new ResourceLocation("forestry", "item/butterfly");
                SimpleModelTransform transform = ResourceUtil.loadTransform(new ResourceLocation("forestry", "item/butterfly"));
                subModelBuilder.put((Object)identifier, (Object)model.func_228813_a_(bakery, model, spriteGetter, (IModelTransform)transform, location, true));
            }
            return new ButterflyItemModel((ImmutableMap<String, IBakedModel>)subModelBuilder.build());
        }

        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.subModels.values().stream().map(location -> new RenderMaterial(PlayerContainer.field_226615_c_, new ResourceLocation(location))).collect(Collectors.toSet());
        }
    }

    private class OverrideList
    extends ItemOverrideList {
        public IBakedModel func_239290_a_(IBakedModel model, ItemStack stack, @Nullable ClientWorld worldIn, @Nullable LivingEntity entityIn) {
            IOrganism organism = GeneticHelper.getOrganism(stack);
            IAlleleButterflySpecies species = organism.getAllele(ButterflyChromosomes.SPECIES, true);
            IAlleleValue<Float> size = organism.getAllele(ButterflyChromosomes.SIZE, true);
            Preconditions.checkNotNull((Object)species);
            Preconditions.checkNotNull(size);
            IBakedModel bakedModel = (IBakedModel)ButterflyItemModel.this.cache.getIfPresent((Object)Pair.of((Object)species.getRegistryName().func_110623_a(), size));
            if (bakedModel != null) {
                return bakedModel;
            }
            float scale = 0.0625f;
            float sizeValue = size.getValue().floatValue();
            String identifier = species.getRegistryName().func_110623_a();
            SimpleModelTransform transform = new SimpleModelTransform(this.getTransformations(sizeValue));
            bakedModel = new PerspectiveMapWrapper((IBakedModel)new TRSRBakedModel((IBakedModel)ButterflyItemModel.this.subModels.get((Object)identifier), 0.0f, 0.0f, 0.0f, 1.0f), (IModelTransform)transform);
            ButterflyItemModel.this.cache.put((Object)Pair.of((Object)identifier, (Object)Float.valueOf(sizeValue)), (Object)bakedModel);
            return bakedModel;
        }

        private ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> getTransformations(float size) {
            float scale = 0.0625f;
            float sSize = size * 1.15f;
            Vector3f scaledSize = new Vector3f(sSize, sSize, sSize);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)new TransformationMatrix(new Vector3f(scale * 0.5f, scale - size / 0.75f * scale, scale * 1.25f), null, scaledSize, null));
            builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)new TransformationMatrix(new Vector3f(0.0f, -scale * 4.75f, 0.0f), null, scaledSize, null));
            builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)new TransformationMatrix(new Vector3f(0.0f, -scale * 4.75f, 0.0f), null, scaledSize, null));
            builder.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)new TransformationMatrix(new Vector3f(0.0f, -scale, 0.0f), new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), 90.0f, true), scaledSize, null));
            builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)new TransformationMatrix(new Vector3f(0.0f, 0.0f, 0.0f), null, scaledSize, null));
            return builder.build();
        }
    }
}

