/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.items;

import forestry.api.core.ISpriteRegister;
import forestry.api.core.ISpriteRegistry;
import forestry.api.core.ItemGroups;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.api.lepidopterology.genetics.EnumFlutterType;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.core.config.Config;
import forestry.core.genetics.ItemGE;
import forestry.core.items.definitions.IColoredItem;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.EntityUtil;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.NetworkUtil;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.features.LepidopterologyEntities;
import forestry.lepidopterology.genetics.ButterflyHelper;
import genetics.api.GeneticHelper;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.individual.IIndividual;
import genetics.api.organism.IOrganismType;
import genetics.utils.AlleleUtils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemButterflyGE
extends ItemGE
implements ISpriteRegister,
IColoredItem {
    private static final Random rand = new Random();
    public static final String NBT_AGE = "Age";
    public static final int MAX_AGE = 3;
    private final EnumFlutterType type;

    public ItemButterflyGE(EnumFlutterType type) {
        super(new Item.Properties().func_200916_a(ItemGroups.tabLepidopterology));
        this.type = type;
    }

    @Override
    protected IAlleleForestrySpecies getSpecies(ItemStack itemStack) {
        return GeneticHelper.getOrganism(itemStack).getAllele(ButterflyChromosomes.SPECIES, true);
    }

    @Override
    protected IOrganismType getType() {
        return this.type;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return GeneticHelper.createOrganism(stack, this.type, ButterflyHelper.getRoot().getDefinition());
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            this.addCreativeItems(subItems, true);
        }
    }

    public void addCreativeItems(NonNullList<ItemStack> subItems, boolean hideSecrets) {
        if (this.type == EnumFlutterType.COCOON) {
            for (int age = 0; age < 3; ++age) {
                for (IButterfly individual : ButterflyManager.butterflyRoot.getIndividualTemplates()) {
                    if (hideSecrets && individual.isSecret() && !Config.isDebug) continue;
                    ItemStack butterfly = ButterflyManager.butterflyRoot.getTypes().createStack(individual, this.type);
                    ItemButterflyGE.setAge(butterfly, age);
                    subItems.add((Object)butterfly);
                }
            }
        } else {
            for (IButterfly individual : ButterflyManager.butterflyRoot.getIndividualTemplates()) {
                if (hideSecrets && individual.isSecret() && !Config.isDebug) continue;
                subItems.add((Object)ButterflyManager.butterflyRoot.getTypes().createStack(individual, this.type));
            }
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entityItem) {
        if (this.type != EnumFlutterType.BUTTERFLY) {
            return false;
        }
        if (entityItem.field_70170_p.field_72995_K || entityItem.field_70173_aa < 80) {
            return false;
        }
        if (rand.nextInt(24) != 0) {
            return false;
        }
        IButterfly butterfly = ButterflyManager.butterflyRoot.getTypes().createIndividual(entityItem.func_92059_d()).orElse(null);
        if (butterfly == null) {
            return false;
        }
        if (butterfly.canTakeFlight(entityItem.field_70170_p, entityItem.func_226277_ct_(), entityItem.func_226278_cu_(), entityItem.func_226281_cx_())) {
            return false;
        }
        EntityUtil.spawnEntity(entityItem.field_70170_p, EntityButterfly.create(LepidopterologyEntities.BUTTERFLY.entityType(), entityItem.field_70170_p, butterfly, entityItem.func_233580_cy_()), entityItem.func_226277_ct_(), entityItem.func_226278_cu_(), entityItem.func_226281_cx_());
        if (!entityItem.func_92059_d().func_190926_b()) {
            entityItem.func_92059_d().func_190918_g(1);
        } else {
            entityItem.func_70106_y();
        }
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        if (world.field_72995_K) {
            return ActionResultType.PASS;
        }
        ItemStack stack = player.func_184586_b(context.func_221531_n());
        IButterfly flutter = ButterflyManager.butterflyRoot.getTypes().createIndividual(stack).orElse(null);
        BlockState blockState = world.func_180495_p(pos);
        if (this.type == EnumFlutterType.COCOON) {
            if ((pos = ButterflyManager.butterflyRoot.plantCocoon((IWorld)world, pos, flutter, player.func_146103_bH(), ItemButterflyGE.getAge(stack), true)) != BlockPos.field_177992_a) {
                PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.SoundFXType.BLOCK_PLACE, pos, blockState);
                NetworkUtil.sendNetworkPacket(packet, pos, world);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        if (this.type == EnumFlutterType.CATERPILLAR) {
            IButterflyNursery nursery = GeneticsUtil.getOrCreateNursery(player.func_146103_bH(), (IWorld)world, pos, true);
            if (nursery != null) {
                if (!nursery.canNurse(flutter)) {
                    return ActionResultType.PASS;
                }
                nursery.setCaterpillar(flutter);
                PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, blockState);
                NetworkUtil.sendNetworkPacket(packet, pos, world);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    public static void setAge(ItemStack cocoon, int age) {
        if (cocoon.func_190926_b()) {
            return;
        }
        if (ButterflyManager.butterflyRoot.getTypes().getType(cocoon).orElse(null) != EnumFlutterType.COCOON) {
            return;
        }
        CompoundNBT tagCompound = cocoon.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
            cocoon.func_77982_d(tagCompound);
        }
        tagCompound.func_74768_a(NBT_AGE, age);
    }

    public static int getAge(ItemStack cocoon) {
        if (cocoon.func_190926_b()) {
            return 0;
        }
        if (ButterflyManager.butterflyRoot.getTypes().getType(cocoon).orElse(null) != EnumFlutterType.COCOON) {
            return 0;
        }
        CompoundNBT tagCompound = cocoon.func_77978_p();
        if (tagCompound == null) {
            return 0;
        }
        return tagCompound.func_74762_e(NBT_AGE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerSprites(ISpriteRegistry registry) {
        AlleleUtils.forEach(ButterflyChromosomes.SPECIES, allele -> allele.registerSprites(registry));
    }

    @Override
    public int getColorFromItemStack(ItemStack stack, int tintIndex) {
        IIndividual individual;
        if (stack.func_77942_o() && (individual = (IIndividual)GeneticHelper.getIndividual(stack).orElse(null)) != null) {
            IAlleleSpecies species = individual.getGenome().getPrimary();
            return ((IAlleleForestrySpecies)species).getSpriteColour(tintIndex);
        }
        return 0xFFFFFF;
    }
}

