/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics.alleles;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import forestry.api.core.ISetupListener;
import forestry.api.core.ISpriteRegistry;
import forestry.api.genetics.products.IDynamicProductList;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.genetics.IAlleleButterflySpecies;
import forestry.api.lepidopterology.genetics.IAlleleButterflySpeciesBuilder;
import forestry.api.lepidopterology.genetics.IButterflyRoot;
import forestry.core.genetics.ProductListWrapper;
import forestry.core.genetics.alleles.AlleleForestrySpecies;
import java.awt.Color;
import java.util.Collection;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AlleleButterflySpecies
extends AlleleForestrySpecies
implements IAlleleButterflySpecies,
ISetupListener {
    private final String texture;
    private final Color serumColour;
    private final float rarity;
    private final float flightDistance;
    private final boolean nocturnal;
    private final Set<Biome.Category> spawnBiomes;
    private ProductListWrapper butterflyLoot;
    private ProductListWrapper caterpillarLoot;

    public AlleleButterflySpecies(Builder builder) {
        super(builder);
        this.texture = builder.texture;
        this.serumColour = builder.serumColour;
        this.rarity = builder.rarity;
        this.flightDistance = builder.flightDistance;
        this.nocturnal = builder.nocturnal;
        this.spawnBiomes = builder.spawnBiomes.build();
        this.butterflyLoot = builder.butterflyLoot;
        this.caterpillarLoot = builder.caterpillarLoot;
    }

    @Override
    public void onFinishSetup() {
        this.butterflyLoot = this.butterflyLoot.bake();
        this.caterpillarLoot = this.caterpillarLoot.bake();
    }

    @Override
    public IButterflyRoot getRoot() {
        return ButterflyManager.butterflyRoot;
    }

    @Override
    public ResourceLocation getEntityTexture() {
        return new ResourceLocation(this.getModID(), "textures/entity/" + this.texture + ".png");
    }

    @Override
    public ResourceLocation getItemTexture() {
        return new ResourceLocation(this.getModID(), "item/" + this.texture);
    }

    @Override
    public Set<Biome.Category> getSpawnBiomes() {
        return this.spawnBiomes;
    }

    @Override
    public boolean strictSpawnMatch() {
        return false;
    }

    @Override
    public int getComplexity() {
        return (int)((double)(1.35f / this.rarity) * 1.5);
    }

    @Override
    public boolean isSecret() {
        return this.rarity < 0.25f;
    }

    @Override
    public float getRarity() {
        return this.rarity;
    }

    @Override
    public float getFlightDistance() {
        return this.flightDistance;
    }

    @Override
    public boolean isNocturnal() {
        return this.nocturnal;
    }

    @Override
    public IDynamicProductList getButterflyLoot() {
        return this.butterflyLoot;
    }

    @Override
    public IDynamicProductList getCaterpillarLoot() {
        return this.caterpillarLoot;
    }

    @Override
    public int getSpriteColour(int renderPass) {
        if (renderPass > 0) {
            return this.serumColour.getRGB() & 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerSprites(ISpriteRegistry registry) {
        registry.addSprite(this.getItemTexture());
    }

    public static class Builder
    extends AlleleForestrySpecies.AbstractBuilder<IAlleleButterflySpeciesBuilder>
    implements IAlleleButterflySpeciesBuilder {
        private final ImmutableSet.Builder<Biome.Category> spawnBiomes = new ImmutableSet.Builder();
        private final ProductListWrapper butterflyLoot = ProductListWrapper.create();
        private final ProductListWrapper caterpillarLoot = ProductListWrapper.create();
        private String texture;
        private Color serumColour = Color.WHITE;
        private float rarity = 0.1f;
        private float flightDistance = 5.0f;
        private boolean nocturnal = false;

        public Builder(String modId, String uid, String speciesIdentifier) {
            super(modId, uid, speciesIdentifier);
        }

        @Override
        public IAlleleButterflySpeciesBuilder cast() {
            return this;
        }

        @Override
        public IAlleleButterflySpecies build() {
            Builder.checkBuilder(this);
            Preconditions.checkNotNull((Object)this.texture);
            return new AlleleButterflySpecies(this);
        }

        @Override
        public IAlleleButterflySpeciesBuilder setRarity(float rarity) {
            this.rarity = rarity;
            return this;
        }

        @Override
        public IAlleleButterflySpeciesBuilder setTexture(String texture) {
            this.texture = texture;
            return this;
        }

        @Override
        public IAlleleButterflySpeciesBuilder setSerumColour(int serumColour) {
            return this.setSerumColour(new Color(serumColour));
        }

        @Override
        public IAlleleButterflySpeciesBuilder setSerumColour(Color serumColour) {
            this.serumColour = serumColour;
            return this;
        }

        @Override
        public IAlleleButterflySpeciesBuilder setFlightDistance(float flightDistance) {
            this.flightDistance = flightDistance;
            return this;
        }

        @Override
        public IAlleleButterflySpeciesBuilder setNocturnal() {
            this.nocturnal = true;
            return this;
        }

        @Override
        public IAlleleButterflySpeciesBuilder addSpawnBiomes(Collection<Biome.Category> biomeTags) {
            this.spawnBiomes.addAll(biomeTags);
            return this;
        }

        @Override
        public IAlleleButterflySpeciesBuilder addSpawnBiome(Biome.Category biomeTag) {
            this.spawnBiomes.add((Object)biomeTag);
            return this;
        }
    }
}

