/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.lepidopterology.entities.AIButterflyBase;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.entities.EnumButterflyState;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.IPlantable;

public class AIButterflyRest
extends AIButterflyBase {
    public AIButterflyRest(EntityButterfly entity) {
        super(entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        int z;
        if (this.entity.getExhaustion() < 1000 && this.entity.canFly()) {
            return false;
        }
        Vector3d entityPos = this.entity.func_213303_ch();
        int x = (int)entityPos.field_72450_a;
        int y = (int)Math.floor(entityPos.field_72448_b);
        BlockPos pos = new BlockPos(x, y, z = (int)entityPos.field_72449_c);
        if (!this.canLand(pos)) {
            return false;
        }
        if (this.entity.field_70170_p.func_175623_d(pos = pos.func_177972_a(Direction.DOWN))) {
            return false;
        }
        BlockState blockState = this.entity.field_70170_p.func_180495_p(pos);
        if (blockState.func_185904_a().func_76224_d()) {
            return false;
        }
        if (!this.entity.getButterfly().isAcceptedEnvironment(this.entity.field_70170_p, x, pos.func_177956_o(), z)) {
            return false;
        }
        this.entity.setDestination(null);
        this.entity.setState(EnumButterflyState.RESTING);
        return true;
    }

    public boolean func_75253_b() {
        if (this.entity.getExhaustion() <= 0 && this.entity.canFly()) {
            return false;
        }
        return !this.entity.func_70090_H();
    }

    public void func_75249_e() {
    }

    public void func_75251_c() {
    }

    public void func_75246_d() {
        this.entity.changeExhaustion(-1);
    }

    private boolean canLand(BlockPos pos) {
        if (!this.entity.field_70170_p.func_175667_e(pos)) {
            return false;
        }
        BlockState blockState = this.entity.field_70170_p.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (!block.isAir(blockState, (IBlockReader)this.entity.field_70170_p, pos)) {
            return false;
        }
        if (AIButterflyRest.isPlant(blockState)) {
            return true;
        }
        BlockState blockStateBelow = this.entity.field_70170_p.func_180495_p(pos.func_177977_b());
        Block blockBelow = blockStateBelow.func_177230_c();
        return AIButterflyRest.isRest(blockBelow) || blockBelow.func_203417_a((ITag)BlockTags.field_206952_E);
    }

    private static boolean isRest(Block block) {
        if (block instanceof FenceBlock) {
            return true;
        }
        return block instanceof WallBlock;
    }

    private static boolean isPlant(BlockState blockState) {
        Block block = blockState.func_177230_c();
        if (block instanceof FlowerBlock) {
            return true;
        }
        if (block instanceof IPlantable) {
            return true;
        }
        if (block instanceof IGrowable) {
            return true;
        }
        return blockState.func_185904_a() == Material.field_151585_k;
    }
}

