/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forestry.Forestry;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.products.Product;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.api.lepidopterology.genetics.IAlleleButterflyCocoon;
import forestry.api.modules.ForestryModule;
import forestry.core.ModuleCore;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.config.forge_old.Property;
import forestry.core.utils.ForgeUtils;
import forestry.core.utils.Log;
import forestry.core.utils.Translator;
import forestry.lepidopterology.ButterflySpawner;
import forestry.lepidopterology.LepidopterologyFilterRule;
import forestry.lepidopterology.LepidopterologyFilterRuleType;
import forestry.lepidopterology.commands.CommandButterfly;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.features.LepidopterologyFeatures;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import forestry.lepidopterology.genetics.ButterflyFactory;
import forestry.lepidopterology.genetics.ButterflyMutationFactory;
import forestry.lepidopterology.genetics.MothDefinition;
import forestry.lepidopterology.genetics.alleles.ButterflyAlleles;
import forestry.lepidopterology.proxy.ProxyLepidopterology;
import forestry.lepidopterology.proxy.ProxyLepidopterologyClient;
import forestry.modules.BlankForestryModule;
import forestry.modules.ISidedModuleHandler;
import forestry.modules.ModuleHelper;
import genetics.api.alleles.IAllele;
import genetics.utils.AlleleUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@ForestryModule(containerID="forestry", moduleID="lepidopterology", name="Lepidopterology", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.lepidopterology.description")
public class ModuleLepidopterology
extends BlankForestryModule {
    public static ProxyLepidopterology proxy;
    private static final String CONFIG_CATEGORY = "lepidopterology";
    public static int spawnConstraint;
    public static int entityConstraint;
    public static int maxDistance;
    private static boolean allowPollination;
    public static final Map<String, Float> spawnRaritys;
    private static boolean spawnButterflysFromLeaves;
    private static boolean generateCocoons;
    private static float generateCocoonsAmount;
    private static float serumChance;
    private static float secondSerumChance;

    public ModuleLepidopterology() {
        proxy = (ProxyLepidopterology)DistExecutor.safeRunForDist(() -> ProxyLepidopterologyClient::new, () -> ProxyLepidopterology::new);
        ForgeUtils.registerSubscriber(this);
        MinecraftForge.EVENT_BUS.register(ForgeEvents.class);
        if (generateCocoons && (double)generateCocoonsAmount > 0.0) {
            IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
            modEventBus.addGenericListener(Feature.class, LepidopterologyFeatures::registerFeatures);
            MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, LepidopterologyFeatures::onBiomeLoad);
        }
    }

    @Override
    public void setupAPI() {
        ButterflyManager.butterflyFactory = new ButterflyFactory();
        ButterflyManager.butterflyMutationFactory = new ButterflyMutationFactory();
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ButterflyDefinition.preInit();
        MothDefinition.preInit();
        proxy.preInitializeRendering();
        if (ModuleHelper.isEnabled("sorting")) {
            LepidopterologyFilterRule.init();
            LepidopterologyFilterRuleType.init();
        }
    }

    @Override
    public Set<ResourceLocation> getDependencyUids() {
        HashSet<ResourceLocation> dependencyUids = new HashSet<ResourceLocation>();
        dependencyUids.add(new ResourceLocation("forestry", "core"));
        dependencyUids.add(new ResourceLocation("forestry", "arboriculture"));
        return dependencyUids;
    }

    @Override
    public void doInit() {
        ModuleCore.rootCommand.then(CommandButterfly.register());
        MothDefinition.initMoths();
        ButterflyDefinition.initButterflies();
        ButterflyAlleles.createLoot();
        if (spawnButterflysFromLeaves) {
            TreeManager.treeRoot.registerLeafTickHandler(new ButterflySpawner());
        }
    }

    @Override
    public void postInit() {
        File configFile = new File(Forestry.instance.getConfigFolder(), "lepidopterology.cfg");
        ModuleLepidopterology.loadConfig(configFile);
    }

    private static void loadConfig(File configFile) {
        LocalizedConfiguration config = new LocalizedConfiguration(configFile, "1.1.0");
        spawnConstraint = config.getIntLocalized("butterfly.entities", "spawn.limit", spawnConstraint, 0, 500);
        entityConstraint = config.getIntLocalized("butterfly.entities", "maximum", entityConstraint, 0, 5000);
        maxDistance = config.getIntLocalized("butterfly.entities", "maxDistance", maxDistance, 0, 256);
        allowPollination = config.getBooleanLocalized("butterfly.entities", "pollination", allowPollination);
        spawnButterflysFromLeaves = config.getBooleanLocalized("butterfly.entities", "spawn.leaves", spawnButterflysFromLeaves);
        generateCocoons = config.getBooleanLocalized("butterfly.cocoons", "generate", generateCocoons);
        generateCocoonsAmount = config.getFloatLocalized("butterfly.cocoons", "generate.amount", generateCocoonsAmount, 0.0f, 10.0f);
        serumChance = config.getFloatLocalized("butterfly.cocoons", "serum", serumChance, 0.0f, 100.0f);
        secondSerumChance = config.getFloatLocalized("butterfly.cocoons", "second.serum", secondSerumChance, 0.0f, 100.0f);
        ModuleLepidopterology.parseRarity(config);
        ModuleLepidopterology.parseCooconLoots(config);
        config.save();
    }

    private static void parseRarity(LocalizedConfiguration config) {
        String[] configRaritys;
        ArrayList butterflyRarity = Lists.newArrayList();
        AlleleUtils.forEach(ButterflyChromosomes.SPECIES, species -> {
            String identifier = species.getRegistryName().toString().replace(':', '_');
            butterflyRarity.add(identifier + ":" + species.getRarity());
        });
        Collections.sort(butterflyRarity);
        String[] defaultRaritys = butterflyRarity.toArray(new String[0]);
        Property rarityConf = config.get("butterfly.alleles", "rarity", defaultRaritys);
        rarityConf.setComment(Translator.translateToLocal("for.config.butterfly.alleles.rarity"));
        for (String rarity : configRaritys = rarityConf.getStringList()) {
            if (!rarity.contains(":") || rarity.length() <= 3) continue;
            String[] raritys = rarity.split(":");
            try {
                spawnRaritys.put(raritys[0], Float.valueOf(Float.parseFloat(raritys[1])));
            }
            catch (Exception e) {
                Log.error("Failed to parse spawn rarity for butterfly. {}", rarity, e);
            }
        }
    }

    private static void parseCooconLoots(LocalizedConfiguration config) {
        for (IAllele iAllele : AlleleUtils.filteredAlleles(ButterflyChromosomes.COCOON)) {
            if (!(iAllele instanceof IAlleleButterflyCocoon)) continue;
            ModuleLepidopterology.parseCooconLoot(config, (IAlleleButterflyCocoon)iAllele);
        }
    }

    private static void parseCooconLoot(LocalizedConfiguration config, IAlleleButterflyCocoon cocoon) {
        HashMap cooconLoot = new HashMap();
        ArrayList<String> lootList = new ArrayList<String>();
        for (Product product : cocoon.getCocoonLoot().getPossibleProducts()) {
            lootList.add(product.getItem().getItem().getRegistryName() + ";" + product.getChance());
        }
        Collections.sort(lootList);
        String[] defaultLoot = lootList.toArray(new String[0]);
        Property lootConf = config.get("butterfly.cocoons.alleles.loot", cocoon.getRegistryName().toString(), defaultLoot);
        lootConf.setComment(Translator.translateToLocal("for.config.butterfly.alleles.loot"));
        String[] configLoot = lootConf.getStringList();
        for (String loot : configLoot) {
            if (!loot.contains(";") || loot.length() <= 3) continue;
            String[] loots = loot.split(";");
            try {
                Object itemStack = null;
                if (itemStack == null) continue;
                cooconLoot.put(itemStack, Float.valueOf(Float.parseFloat(loots[1])));
            }
            catch (Exception e) {
                Log.error("Failed to parse cocoon loot. {}", loot, e);
            }
        }
        cocoon.clearLoot();
        for (Map.Entry entry : cooconLoot.entrySet()) {
            cocoon.addLoot((ItemStack)entry.getKey(), ((Float)entry.getValue()).floatValue());
        }
        cocoon.bakeLoot();
    }

    @Override
    public void registerRecipes() {
    }

    public static boolean isPollinationAllowed() {
        return allowPollination;
    }

    public static boolean isSpawnButterflysFromLeaves() {
        return spawnButterflysFromLeaves;
    }

    public static boolean isGenerateCocoons() {
        return generateCocoons;
    }

    public static float getGenerateCocoonsAmount() {
        return generateCocoonsAmount;
    }

    public static float getSerumChance() {
        return serumChance;
    }

    public static float getSecondSerumChance() {
        return secondSerumChance;
    }

    @Override
    public ISidedModuleHandler getModuleHandler() {
        return proxy;
    }

    static {
        spawnConstraint = 100;
        entityConstraint = 1000;
        maxDistance = 64;
        allowPollination = true;
        spawnRaritys = Maps.newHashMap();
        spawnButterflysFromLeaves = true;
        generateCocoons = false;
        generateCocoonsAmount = 1.0f;
        serumChance = 0.55f;
        secondSerumChance = 0.0f;
    }

    private class ForgeEvents {
        private ForgeEvents() {
        }

        @SubscribeEvent
        public void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
            if (event.getEntity() instanceof EntityButterfly) {
                event.setCanceled(true);
            }
        }
    }
}

