/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.farmables;

import com.google.common.base.Preconditions;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.api.farming.IFarmableInfo;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.crops.CropDestroy;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmableAgingCrop
implements IFarmable {
    protected final ItemStack germling;
    protected final Block cropBlock;
    protected final Property<Integer> ageProperty;
    protected final int minHarvestAge;
    @Nullable
    protected final Integer replantAge;
    protected final ItemStack[] products;

    public FarmableAgingCrop(ItemStack germling, Block cropBlock, Property<Integer> ageProperty, int minHarvestAge) {
        this(germling, cropBlock, new ItemStack[0], ageProperty, minHarvestAge, null);
    }

    public FarmableAgingCrop(ItemStack germling, Block cropBlock, Property<Integer> ageProperty, int minHarvestAge, @Nullable Integer replantAge) {
        this(germling, cropBlock, new ItemStack[0], ageProperty, minHarvestAge, replantAge);
    }

    public FarmableAgingCrop(ItemStack germling, Block cropBlock, ItemStack product, Property<Integer> ageProperty, int minHarvestAge) {
        this(germling, cropBlock, new ItemStack[]{product}, ageProperty, minHarvestAge, null);
    }

    public FarmableAgingCrop(ItemStack germling, Block cropBlock, ItemStack product, Property<Integer> ageProperty, int minHarvestAge, @Nullable Integer replantAge) {
        this(germling, cropBlock, new ItemStack[]{product}, ageProperty, minHarvestAge, replantAge);
    }

    public FarmableAgingCrop(ItemStack germling, Block cropBlock, ItemStack[] products, Property<Integer> ageProperty, int minHarvestAge) {
        this(germling, cropBlock, products, ageProperty, minHarvestAge, null);
    }

    public FarmableAgingCrop(ItemStack germling, Block cropBlock, ItemStack[] products, Property<Integer> ageProperty, int minHarvestAge, @Nullable Integer replantAge) {
        Preconditions.checkNotNull((Object)germling);
        Preconditions.checkNotNull((Object)cropBlock);
        Preconditions.checkNotNull(ageProperty);
        Preconditions.checkNotNull((Object)products);
        this.germling = germling;
        this.cropBlock = cropBlock;
        this.ageProperty = ageProperty;
        this.minHarvestAge = minHarvestAge;
        this.replantAge = replantAge;
        this.products = products;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos, BlockState blockState) {
        return blockState.func_177230_c() == this.cropBlock && (Integer)blockState.func_177229_b(this.ageProperty) <= this.minHarvestAge;
    }

    @Override
    @Nullable
    public ICrop getCropAt(World world, BlockPos pos, BlockState blockState) {
        if (blockState.func_177230_c() != this.cropBlock) {
            return null;
        }
        if ((Integer)blockState.func_177229_b(this.ageProperty) < this.minHarvestAge) {
            return null;
        }
        BlockState replantState = this.getReplantState(blockState);
        return new CropDestroy(world, blockState, pos, replantState, this.germling);
    }

    @Nullable
    protected BlockState getReplantState(BlockState blockState) {
        if (this.replantAge == null) {
            return null;
        }
        return (BlockState)blockState.func_206870_a(this.ageProperty, (Comparable)this.replantAge);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return ItemStack.func_179545_c((ItemStack)this.germling, (ItemStack)itemstack);
    }

    @Override
    public void addInformation(IFarmableInfo info) {
        info.addProducts(this.products);
        info.addSeedlings(this.germling);
    }

    @Override
    public boolean plantSaplingAt(PlayerEntity player, ItemStack germling, World world, BlockPos pos) {
        BlockState plantedState = (BlockState)this.cropBlock.func_176223_P().func_206870_a(this.ageProperty, (Comparable)Integer.valueOf(0));
        return BlockUtil.setBlockWithPlaceSound(world, pos, plantedState);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

