/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import com.google.common.collect.ImmutableList;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.IFarmable;
import forestry.api.genetics.IFruitBearer;
import forestry.core.tiles.TileUtil;
import forestry.farming.logic.FarmLogic;
import forestry.farming.logic.crops.CropFruit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class FarmLogicOrchard
extends FarmLogic {
    private final ImmutableList<Block> traversalBlocks;

    public FarmLogicOrchard(IFarmProperties properties, boolean isManual) {
        super(properties, isManual);
        ImmutableList.Builder traversalBlocksBuilder = ImmutableList.builder();
        this.traversalBlocks = traversalBlocksBuilder.build();
    }

    @Override
    public Collection<ICrop> harvest(World world, IFarmHousing housing, FarmDirection direction, int extent, BlockPos pos) {
        BlockPos position = housing.getValidPosition(direction, pos, extent, pos.func_177984_a());
        Collection<ICrop> crops = this.getHarvestBlocks(world, position);
        housing.increaseExtent(direction, pos, extent);
        return crops;
    }

    private Collection<ICrop> getHarvestBlocks(World world, BlockPos position) {
        HashSet<BlockPos> seen = new HashSet<BlockPos>();
        Stack<ICrop> crops = new Stack<ICrop>();
        if (!world.func_175667_e(position)) {
            return Collections.emptyList();
        }
        BlockState blockState = world.func_180495_p(position);
        Block block = blockState.func_177230_c();
        List<BlockPos> candidates = this.processHarvestBlock(world, crops, seen, position, position);
        ArrayList<BlockPos> temp = new ArrayList<BlockPos>();
        while (!candidates.isEmpty() && crops.size() < 20) {
            for (BlockPos candidate : candidates) {
                temp.addAll(this.processHarvestBlock(world, crops, seen, position, candidate));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private List<BlockPos> processHarvestBlock(World world, Stack<ICrop> crops, Set<BlockPos> seen, BlockPos start, BlockPos position) {
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (int i = -2; i < 3; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    BlockPos candidate = position.func_177982_a(i, j, k);
                    if (Math.abs(candidate.func_177958_n() - start.func_177958_n()) > 5 || Math.abs(candidate.func_177952_p() - start.func_177952_p()) > 5 || seen.contains(candidate) || !world.func_175667_e(candidate) || world.func_175623_d(candidate)) continue;
                    BlockState blockState = world.func_180495_p(candidate);
                    Block block = blockState.func_177230_c();
                    if (!this.isFruitBearer(world, candidate, blockState)) continue;
                    candidates.add(candidate);
                    seen.add(candidate);
                    ICrop crop = this.getCropAt(world, candidate);
                    if (crop == null) continue;
                    crops.push(crop);
                }
            }
        }
        return candidates;
    }

    private boolean isFruitBearer(World world, BlockPos position, BlockState blockState) {
        IFruitBearer tile = TileUtil.getTile((IBlockReader)world, position, IFruitBearer.class);
        if (tile != null) {
            return true;
        }
        for (IFarmable farmable : this.getFarmables()) {
            if (!farmable.isSaplingAt(world, position, blockState)) continue;
            return true;
        }
        return false;
    }

    private static boolean isBlockTraversable(BlockState blockState, ImmutableList<Block> traversalBlocks) {
        Block candidate = blockState.func_177230_c();
        for (Block block : traversalBlocks) {
            if (block != candidate) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private ICrop getCropAt(World world, BlockPos position) {
        IFruitBearer fruitBearer = TileUtil.getTile((IBlockReader)world, position, IFruitBearer.class);
        if (fruitBearer != null) {
            if (fruitBearer.hasFruit() && fruitBearer.getRipeness() >= 0.9f) {
                return new CropFruit(world, position);
            }
        } else {
            return this.getCrop(world, position);
        }
        return null;
    }
}

