/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import com.google.common.collect.ImmutableSet;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.FarmLogicHomogeneous;
import forestry.farming.logic.crops.CropDestroy;
import forestry.farming.logic.farmables.FarmableChorus;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.Stack;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmLogicEnder
extends FarmLogicHomogeneous {
    private static final Set<Direction> VALID_DIRECTIONS = ImmutableSet.of((Object)Direction.UP, (Object)Direction.NORTH, (Object)Direction.SOUTH, (Object)Direction.WEST, (Object)Direction.EAST);
    private final IFarmable chorusFarmable = FarmableChorus.INSTANCE;

    public FarmLogicEnder(IFarmProperties properties, boolean isManual) {
        super(properties, isManual);
    }

    @Override
    public NonNullList<ItemStack> collect(World world, IFarmHousing farmHousing) {
        return this.collectEntityItems(world, farmHousing, true);
    }

    @Override
    public Collection<ICrop> harvest(World world, IFarmHousing farmHousing, FarmDirection direction, int extent, BlockPos pos) {
        BlockPos position = farmHousing.getValidPosition(direction, pos, extent, pos.func_177984_a());
        Collection<ICrop> crops = this.harvestBlocks(world, position);
        farmHousing.increaseExtent(direction, pos, extent);
        return crops;
    }

    private Collection<ICrop> harvestBlocks(World world, BlockPos position) {
        if (!world.func_175667_e(position) || world.func_175623_d(position)) {
            return Collections.emptySet();
        }
        ICrop crop = this.getCrop(world, position);
        if (crop != null) {
            return Collections.singleton(crop);
        }
        Stack<ICrop> crops = new Stack<ICrop>();
        Stack<ICrop> plants = new Stack<ICrop>();
        this.harvestBlock(world, position, Direction.DOWN, plants, crops);
        if (!crops.isEmpty()) {
            return crops;
        }
        return plants;
    }

    private boolean harvestBlock(World world, BlockPos pos, Direction from, Stack<ICrop> plants, Stack<ICrop> flowers) {
        BlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c() == Blocks.field_185766_cS) {
            ICrop crop = this.chorusFarmable.getCropAt(world, pos, blockState);
            if (crop != null) {
                flowers.push(crop);
                return false;
            }
            return false;
        }
        if (blockState.func_177230_c() == Blocks.field_185765_cR) {
            boolean canHarvest = true;
            for (Direction facing : VALID_DIRECTIONS) {
                if (facing == from) continue;
                canHarvest &= this.harvestBlock(world, pos.func_177972_a(facing), facing.func_176734_d(), plants, flowers);
            }
            if (canHarvest) {
                plants.push(new CropDestroy(world, Blocks.field_185765_cR.func_176223_P(), pos, null));
            }
            return canHarvest;
        }
        return true;
    }

    @Override
    protected boolean maintainSeedlings(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            BlockPos soilPos;
            BlockState blockState;
            BlockPos position = this.translateWithOffset(pos, direction, i);
            BlockState state = world.func_180495_p(position);
            if (!world.func_175623_d(position) && !BlockUtil.isReplaceableBlock(state, world, position) || !this.isAcceptedSoil(blockState = world.func_180495_p(soilPos = position.func_177977_b())) || !this.trySetCrop(world, farmHousing, position, direction)) continue;
            return true;
        }
        return false;
    }
}

