/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.IFarmable;
import forestry.farming.logic.FarmLogicHomogeneous;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmLogicArboreal
extends FarmLogicHomogeneous {
    @Nullable
    private List<IFarmable> farmables;

    public FarmLogicArboreal(IFarmProperties properties, boolean isManual) {
        super(properties, isManual);
    }

    public List<IFarmable> getFarmables() {
        if (this.farmables == null) {
            this.farmables = new ArrayList<IFarmable>(this.properties.getFarmables());
        }
        return this.farmables;
    }

    @Override
    public NonNullList<ItemStack> collect(World world, IFarmHousing farmHousing) {
        return this.collectEntityItems(world, farmHousing, true);
    }

    @Override
    public Collection<ICrop> harvest(World world, IFarmHousing farmHousing, FarmDirection direction, int extent, BlockPos pos) {
        BlockPos position = farmHousing.getValidPosition(direction, pos, extent, pos.func_177984_a());
        Collection<ICrop> crops = this.harvestBlocks(world, position);
        farmHousing.increaseExtent(direction, pos, extent);
        return crops;
    }

    private Collection<ICrop> harvestBlocks(World world, BlockPos position) {
        IFarmable farmable = FarmLogicArboreal.getFarmableForBlock(world, position, this.getFarmables());
        if (farmable == null) {
            return Collections.emptyList();
        }
        Stack<BlockPos> knownCropPositions = new Stack<BlockPos>();
        knownCropPositions.add(position);
        HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
        Stack<ICrop> crops = new Stack<ICrop>();
        while (!knownCropPositions.empty()) {
            BlockPos knownCropPos = (BlockPos)knownCropPositions.pop();
            for (BlockPos mutable : BlockPos.func_218278_a((BlockPos)knownCropPos.func_177982_a(-1, -1, -1), (BlockPos)knownCropPos.func_177982_a(1, 1, 1))) {
                if (!world.func_175667_e(mutable)) {
                    return crops;
                }
                BlockPos candidate = mutable.func_185334_h();
                if (checkedBlocks.contains(candidate)) continue;
                checkedBlocks.add(candidate);
                BlockState blockState = world.func_180495_p(candidate);
                ICrop crop = farmable.getCropAt(world, candidate, blockState);
                if (crop == null) continue;
                crops.push(crop);
                knownCropPositions.push(candidate);
            }
        }
        return crops;
    }

    @Nullable
    private static IFarmable getFarmableForBlock(World world, BlockPos position, Collection<IFarmable> farmables) {
        if (world.func_175623_d(position)) {
            return null;
        }
        BlockState blockState = world.func_180495_p(position);
        for (IFarmable farmable : farmables) {
            ICrop crop = farmable.getCropAt(world, position, blockState);
            if (crop == null) continue;
            return farmable;
        }
        return null;
    }

    @Override
    protected boolean maintainSeedlings(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            BlockPos soilPosition;
            BlockState soilState;
            BlockPos position = this.translateWithOffset(pos, direction, i);
            if (!world.func_175623_d(position) || !this.isAcceptedSoil(soilState = world.func_180495_p(soilPosition = position.func_177977_b()))) continue;
            return this.plantSapling(world, farmHousing, position, direction);
        }
        return false;
    }

    private boolean plantSapling(World world, IFarmHousing farmHousing, BlockPos position, FarmDirection direction) {
        Collections.shuffle(this.getFarmables());
        for (IFarmable candidate : this.getFarmables()) {
            if (!farmHousing.plantGermling(candidate, world, position, direction)) continue;
            return true;
        }
        return false;
    }
}

