/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming;

import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeRoot;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.farming.FarmPropertiesEvent;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.IFarmPropertiesBuilder;
import forestry.arboriculture.genetics.alleles.AlleleFruits;
import forestry.core.circuits.Circuits;
import forestry.core.features.CoreBlocks;
import forestry.core.features.CoreItems;
import forestry.core.items.ItemFruit;
import forestry.core.items.definitions.EnumElectronTube;
import forestry.core.utils.ForgeUtils;
import forestry.farming.FarmRegistry;
import forestry.farming.circuits.CircuitFarmLogic;
import forestry.farming.logic.FarmLogicArboreal;
import forestry.farming.logic.FarmLogicCocoa;
import forestry.farming.logic.FarmLogicCrops;
import forestry.farming.logic.FarmLogicEnder;
import forestry.farming.logic.FarmLogicGourd;
import forestry.farming.logic.FarmLogicInfernal;
import forestry.farming.logic.FarmLogicMushroom;
import forestry.farming.logic.FarmLogicOrchard;
import forestry.farming.logic.FarmLogicPeat;
import forestry.farming.logic.FarmLogicReeds;
import forestry.farming.logic.FarmLogicSucculent;
import forestry.modules.ModuleHelper;
import java.util.Collection;
import java.util.function.BiFunction;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import org.apache.commons.lang3.text.WordUtils;

public enum FarmDefinition implements IStringSerializable
{
    CROPS("crops", EnumElectronTube.BRONZE, FarmLogicCrops::new){

        @Override
        protected void initProperties(IFarmPropertiesBuilder properties) {
            this.wateredProperties(properties).addSoil(new ItemStack((IItemProvider)Blocks.field_150346_d), Blocks.field_150458_ak.func_176223_P()).addFarmables("Wheat").setIcon(() -> new ItemStack((IItemProvider)Items.field_151015_O));
        }
    }
    ,
    GOURD("gourd", EnumElectronTube.LAPIS, FarmLogicGourd::new){

        @Override
        protected void initProperties(IFarmPropertiesBuilder properties) {
            properties.setIcon(() -> new ItemStack((IItemProvider)Items.field_221794_dg)).setFertilizer(10).setWater(hydrationModifier -> (int)(40.0f * hydrationModifier.floatValue()));
        }
    }
    ,
    SHROOM("shroom", EnumElectronTube.APATITE, FarmLogicMushroom::new){

        @Override
        protected void initProperties(IFarmPropertiesBuilder properties) {
            properties.addSoil(Blocks.field_150391_bh).addSoil(Blocks.field_196661_l).setWater(hydrationModifier -> (int)(80.0f * hydrationModifier.floatValue())).setFertilizer(20).setIcon(() -> new ItemStack((IItemProvider)Blocks.field_150337_Q));
        }
    }
    ,
    INFERNAL("infernal", EnumElectronTube.BLAZE, FarmLogicInfernal::new){

        @Override
        protected void initProperties(IFarmPropertiesBuilder properties) {
            properties.addSoil(Blocks.field_150425_aM).setWater(0).setFertilizer(20).setIcon(() -> new ItemStack((IItemProvider)Items.field_151075_bm));
        }
    }
    ,
    POALES("poales", EnumElectronTube.TIN, FarmLogicReeds::new){

        @Override
        protected void initProperties(IFarmPropertiesBuilder properties) {
            properties.addSoil(Blocks.field_150354_m).addSoil(Blocks.field_150346_d).setFertilizer(10).setWater(hydrationModifier -> (int)(20.0f * hydrationModifier.floatValue())).setIcon(() -> new ItemStack((IItemProvider)Items.field_222065_kN));
        }
    }
    ,
    SUCCULENTES("succulentes", EnumElectronTube.COPPER, FarmLogicSucculent::new){

        @Override
        protected void initProperties(IFarmPropertiesBuilder properties) {
            properties.addSoil(Blocks.field_150354_m).setFertilizer(10).setWater(1).setIcon(() -> new ItemStack((IItemProvider)Items.field_222079_lj));
        }
    }
    ,
    ENDER("ender", EnumElectronTube.ENDER, FarmLogicEnder::new){

        @Override
        protected void initProperties(IFarmPropertiesBuilder properties) {
            properties.addSoil(Blocks.field_150377_bs).setIcon(() -> new ItemStack((IItemProvider)Items.field_151061_bv)).setFertilizer(20).setWater(0);
        }
    }
    ,
    ARBOREAL("arboreal", EnumElectronTube.GOLD, FarmLogicArboreal::new){

        @Override
        protected void initProperties(IFarmPropertiesBuilder properties) {
            properties.addSoil(new ItemStack((IItemProvider)Blocks.field_150346_d), CoreBlocks.HUMUS.defaultState()).addSoil(CoreBlocks.HUMUS.stack(), CoreBlocks.HUMUS.defaultState()).addProducts(new ItemStack((IItemProvider)Blocks.field_150354_m)).setFertilizer(10).setWater(hydrationModifier -> (int)(10.0f * hydrationModifier.floatValue())).setIcon(() -> new ItemStack((IItemProvider)Blocks.field_196674_t));
        }
    }
    ,
    PEAT("peat", EnumElectronTube.OBSIDIAN, FarmLogicPeat::new){

        @Override
        protected void initProperties(IFarmPropertiesBuilder properties) {
            this.wateredProperties(properties).addSoil(CoreBlocks.BOG_EARTH.stack(), CoreBlocks.BOG_EARTH.defaultState()).addProducts(CoreItems.PEAT.stack(), new ItemStack((IItemProvider)Blocks.field_150346_d)).setIcon(CoreItems.PEAT::stack).setFertilizer(2);
        }
    }
    ,
    ORCHARD("orchard", EnumElectronTube.EMERALD, FarmLogicOrchard::new){

        @Override
        protected void initProperties(IFarmPropertiesBuilder properties) {
            ITreeRoot treeRoot;
            properties.setFertilizer(10).setWater(hydrationModifier -> (int)(40.0f * hydrationModifier.floatValue())).setIcon(() -> CoreItems.FRUITS.stack(ItemFruit.EnumFruit.CHERRY));
            if (ModuleHelper.isEnabled("arboriculture") && (treeRoot = TreeManager.treeRoot) != null) {
                for (ITree tree : treeRoot.getIndividualTemplates()) {
                    IFruitProvider fruitProvider = tree.getGenome().getActiveAllele(TreeChromosomes.FRUITS).getProvider();
                    if (fruitProvider == AlleleFruits.fruitNone.getProvider()) continue;
                    properties.addSeedlings(treeRoot.getTypes().createStack(tree, EnumGermlingType.SAPLING)).addProducts((Collection<ItemStack>)fruitProvider.getProducts().getPossibleStacks()).addProducts((Collection<ItemStack>)fruitProvider.getSpecialty().getPossibleStacks());
                }
            }
        }
    }
    ,
    COCOA("cocoa", EnumElectronTube.DIAMOND, FarmLogicCocoa::new){

        @Override
        protected void initProperties(IFarmPropertiesBuilder properties) {
            properties.addSoil(Blocks.field_196620_N).addSeedlings(new ItemStack((IItemProvider)Items.field_196130_bo)).addProducts(new ItemStack((IItemProvider)Items.field_196130_bo)).setFertilizer(120).setWater(hydrationModifier -> (int)(20.0f * hydrationModifier.floatValue())).setIcon(() -> new ItemStack((IItemProvider)Items.field_196130_bo));
        }
    };

    private final String name;
    private final EnumElectronTube tube;
    protected final IFarmProperties properties;
    private final String module;
    private final ICircuit managed;
    private final ICircuit manual;

    private FarmDefinition(String identifier, EnumElectronTube tube, BiFunction<IFarmProperties, Boolean, IFarmLogic> factory) {
        this(identifier, tube, factory, "farming");
    }

    private FarmDefinition(String identifier, EnumElectronTube tube, BiFunction<IFarmProperties, Boolean, IFarmLogic> factory, String module) {
        String camelCase = WordUtils.capitalize((String)identifier);
        IFarmPropertiesBuilder builder = FarmRegistry.getInstance().getPropertiesBuilder(identifier).setFactory(factory).setTranslationKey("for.farm." + identifier).addFarmables("farm" + camelCase);
        this.initProperties(builder);
        ForgeUtils.postEvent(new FarmPropertiesEvent(identifier, builder));
        this.properties = builder.create();
        this.managed = new CircuitFarmLogic("managed" + camelCase, this.properties, false);
        this.manual = new CircuitFarmLogic("manual" + camelCase, this.properties, true);
        this.name = identifier;
        this.tube = tube;
        this.module = module;
    }

    protected IFarmPropertiesBuilder wateredProperties(IFarmPropertiesBuilder builder) {
        return builder.setWater(hydrationModifier -> (int)(20.0f * hydrationModifier.floatValue())).setFertilizer(5);
    }

    protected void initProperties(IFarmPropertiesBuilder properties) {
    }

    protected void registerCircuits(ICircuitLayout layoutManaged, ICircuitLayout layoutManual) {
        ChipsetManager.solderManager.addRecipe(layoutManaged, CoreItems.ELECTRON_TUBES.stack(this.tube, 1), this.managed);
        ChipsetManager.solderManager.addRecipe(layoutManual, CoreItems.ELECTRON_TUBES.stack(this.tube, 1), this.manual);
    }

    public String func_176610_l() {
        return this.name;
    }

    public IFarmProperties getProperties() {
        return this.properties;
    }

    public static void registerCircuits() {
        ICircuitLayout layoutManaged = ChipsetManager.circuitRegistry.getLayout("forestry.farms.managed");
        ICircuitLayout layoutManual = ChipsetManager.circuitRegistry.getLayout("forestry.farms.manual");
        if (layoutManaged == null || layoutManual == null) {
            return;
        }
        for (FarmDefinition definition : FarmDefinition.values()) {
            definition.registerCircuits(layoutManaged, layoutManual);
        }
    }

    public static void init() {
        Circuits.farmArborealManaged = FarmDefinition.ARBOREAL.managed;
        Circuits.farmArborealManual = FarmDefinition.ARBOREAL.manual;
        Circuits.farmShroomManaged = FarmDefinition.SHROOM.managed;
        Circuits.farmShroomManual = FarmDefinition.SHROOM.manual;
        Circuits.farmPeatManaged = FarmDefinition.PEAT.managed;
        Circuits.farmPeatManual = FarmDefinition.PEAT.manual;
        Circuits.farmCropsManaged = FarmDefinition.CROPS.managed;
        Circuits.farmCropsManual = FarmDefinition.CROPS.manual;
        Circuits.farmInfernalManaged = FarmDefinition.INFERNAL.managed;
        Circuits.farmInfernalManual = FarmDefinition.INFERNAL.manual;
        Circuits.farmOrchardManaged = FarmDefinition.ORCHARD.managed;
        Circuits.farmOrchardManual = FarmDefinition.ORCHARD.manual;
        Circuits.farmSucculentManaged = FarmDefinition.SUCCULENTES.managed;
        Circuits.farmSucculentManual = FarmDefinition.SUCCULENTES.manual;
        Circuits.farmPoalesManaged = FarmDefinition.POALES.managed;
        Circuits.farmPoalesManual = FarmDefinition.POALES.manual;
        Circuits.farmGourdManaged = FarmDefinition.GOURD.managed;
        Circuits.farmGourdManual = FarmDefinition.GOURD.manual;
        Circuits.farmCocoaManaged = FarmDefinition.COCOA.managed;
        Circuits.farmCocoaManual = FarmDefinition.COCOA.manual;
        Circuits.farmEnderManaged = FarmDefinition.ENDER.managed;
        Circuits.farmEnderManual = FarmDefinition.ENDER.manual;
    }
}

