/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.fuels.RainSubstrate;
import forestry.core.render.ParticleRender;
import forestry.core.tiles.TileMill;
import forestry.factory.features.FactoryTiles;
import forestry.factory.inventory.InventoryRainmaker;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.storage.IServerWorldInfo;

public class TileMillRainmaker
extends TileMill {
    private int duration;
    private boolean reverse;

    public TileMillRainmaker() {
        super(FactoryTiles.RAINMAKER.tileType());
        this.speed = 0.01f;
        this.setInternalInventory(new InventoryRainmaker(this));
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        this.charge = compoundNBT.func_74762_e("Charge");
        this.progress = compoundNBT.func_74760_g("Progress");
        this.stage = compoundNBT.func_74762_e("Stage");
        this.duration = compoundNBT.func_74762_e("Duration");
        this.reverse = compoundNBT.func_74767_n("Reverse");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        compoundNBT.func_74768_a("Charge", this.charge);
        compoundNBT.func_74776_a("Progress", this.progress);
        compoundNBT.func_74768_a("Stage", this.stage);
        compoundNBT.func_74768_a("Duration", this.duration);
        compoundNBT.func_74757_a("Reverse", this.reverse);
        return compoundNBT;
    }

    public void addCharge(RainSubstrate substrate) {
        this.charge = 1;
        this.speed = substrate.getSpeed();
        this.duration = substrate.getDuration();
        this.reverse = substrate.isReverse();
        this.sendNetworkUpdate();
    }

    @Override
    public void activate() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187754_de, SoundCategory.WEATHER, 10000.0f, 0.8f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
            float f = (float)this.func_174877_v().func_177958_n() + 0.5f;
            float f1 = (float)this.func_174877_v().func_177956_o() + 0.0f + this.field_145850_b.field_73012_v.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)this.func_174877_v().func_177952_p() + 0.5f;
            float f3 = 0.52f;
            float f4 = this.field_145850_b.field_73012_v.nextFloat() * 0.6f - 0.3f;
            ParticleRender.addEntityExplodeFX(this.field_145850_b, f - f3, f1, f2 + f4);
            ParticleRender.addEntityExplodeFX(this.field_145850_b, f + f3, f1, f2 + f4);
            ParticleRender.addEntityExplodeFX(this.field_145850_b, f + f4, f1, f2 - f3);
            ParticleRender.addEntityExplodeFX(this.field_145850_b, f + f4, f1, f2 + f3);
        } else {
            if (this.reverse) {
                this.field_145850_b.func_72912_H().func_76084_b(false);
            } else {
                this.field_145850_b.func_72912_H().func_76084_b(true);
                ((IServerWorldInfo)this.field_145850_b.func_72912_H()).func_76080_g(this.duration);
            }
            this.charge = 0;
            this.duration = 0;
            this.reverse = false;
            this.sendNetworkUpdate();
        }
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return null;
    }

    @Override
    protected boolean hasGui() {
        return false;
    }
}

