/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.IErrorLogic;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.StandardTank;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.watchers.ISlotPickupWatcher;
import forestry.core.network.PacketBufferForestry;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.factory.features.FactoryTiles;
import forestry.factory.gui.ContainerBottler;
import forestry.factory.inventory.InventoryBottler;
import forestry.factory.recipes.BottlerRecipe;
import java.io.IOException;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileBottler
extends TilePowered
implements ISidedInventory,
ILiquidTankTile,
ISlotPickupWatcher {
    private static final int TICKS_PER_RECIPE_TIME = 5;
    private static final int ENERGY_PER_RECIPE_TIME = 1000;
    private final StandardTank resourceTank;
    private final TankManager tankManager;
    private final EnumMap<Direction, Boolean> canDump;
    private boolean dumpingFluid = false;
    @Nullable
    private BottlerRecipe currentRecipe;
    @OnlyIn(value=Dist.CLIENT)
    public boolean isFillRecipe;

    public TileBottler() {
        super(FactoryTiles.BOTTLER.tileType(), 1100, 4000);
        this.setInternalInventory(new InventoryBottler(this));
        this.resourceTank = new StandardTank(10000);
        this.tankManager = new TankManager(this, this.resourceTank);
        this.canDump = new EnumMap(Direction.class);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        this.tankManager.write(compound);
        return compound;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.tankManager.read(compound);
        this.checkEmptyRecipe();
        this.checkFillRecipe();
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            ItemStack inputStack;
            ItemStack leftProcessingStack = this.func_70301_a(2);
            ItemStack rightProcessingStack = this.func_70301_a(3);
            if (leftProcessingStack.func_190926_b() && !(inputStack = this.func_70301_a(0)).func_190926_b()) {
                leftProcessingStack = this.func_70298_a(0, 1);
                this.func_70299_a(2, leftProcessingStack);
            }
            if (rightProcessingStack.func_190926_b() && !(inputStack = this.func_70301_a(1)).func_190926_b()) {
                rightProcessingStack = this.func_70298_a(1, 1);
                this.func_70299_a(3, rightProcessingStack);
            }
        }
        if (this.canDump() && (this.dumpingFluid || this.updateOnInterval(20))) {
            this.dumpingFluid = this.dumpFluid();
        }
    }

    private boolean canDump() {
        FluidStack fluid = this.tankManager.getFluid(0);
        if (fluid != null) {
            if (this.canDump.isEmpty()) {
                for (Direction facing : Direction.field_199792_n) {
                    this.canDump.put(facing, FluidHelper.canAcceptFluid(this.field_145850_b, this.field_174879_c.func_177972_a(facing), facing.func_176734_d(), fluid));
                }
            }
            for (Direction facing : Direction.field_199792_n) {
                if (!this.canDump.get(facing).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean dumpFluid() {
        if (!this.resourceTank.isEmpty()) {
            for (Direction facing : Direction.field_199792_n) {
                LazyOptional fluidDestination;
                if (!this.canDump.get(facing).booleanValue() || !(fluidDestination = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(facing), (Direction)facing.func_176734_d())).isPresent()) continue;
                fluidDestination.ifPresent(f -> FluidUtil.tryFluidTransfer((IFluidHandler)f, (IFluidHandler)this.tankManager, (int)50, (boolean)true));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean workCycle() {
        FluidHelper.FillStatus status;
        if (this.currentRecipe != null) {
            status = this.currentRecipe.fillRecipe ? FluidHelper.fillContainers(this.tankManager, (IInventory)this, 3, 5, this.currentRecipe.fluid.getFluid(), true) : FluidHelper.drainContainers(this.tankManager, (IInventory)this, 2, 4, true);
        } else {
            return true;
        }
        if (status == FluidHelper.FillStatus.SUCCESS) {
            this.currentRecipe = null;
            return true;
        }
        return false;
    }

    @Override
    public void onNeighborTileChange(World world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborTileChange(world, pos, neighbor);
        this.canDump.clear();
    }

    private void checkFillRecipe() {
        ItemStack emptyCan = this.func_70301_a(3);
        if (!emptyCan.func_190926_b()) {
            FluidStack resource = this.resourceTank.getFluid();
            if (resource.isEmpty()) {
                return;
            }
            if (this.currentRecipe == null || !this.currentRecipe.matchEmpty(emptyCan, resource)) {
                this.currentRecipe = BottlerRecipe.createFillingRecipe(resource.getFluid(), emptyCan);
                if (this.currentRecipe != null) {
                    float viscosityMultiplier = (float)resource.getFluid().getAttributes().getViscosity(resource) / 1000.0f;
                    viscosityMultiplier = (viscosityMultiplier - 1.0f) / 20.0f + 1.0f;
                    int fillAmount = Math.min(this.currentRecipe.fluid.getAmount(), resource.getAmount());
                    float fillTime = (float)fillAmount / 1000.0f;
                    this.setTicksPerWorkCycle(Math.round((fillTime *= viscosityMultiplier) * 5.0f));
                    this.setEnergyPerWorkCycle(Math.round(fillTime * 1000.0f));
                }
            }
        }
    }

    private void checkEmptyRecipe() {
        ItemStack filledCan = this.func_70301_a(2);
        if (!(filledCan.func_190926_b() || this.currentRecipe != null && (this.currentRecipe.matchFilled(filledCan) || this.currentRecipe.fillRecipe))) {
            this.currentRecipe = BottlerRecipe.createEmptyingRecipe(filledCan);
            if (this.currentRecipe != null) {
                FluidStack resource = this.currentRecipe.fluid;
                float viscosityMultiplier = (float)resource.getFluid().getAttributes().getViscosity(resource) / 1000.0f;
                viscosityMultiplier = (viscosityMultiplier - 1.0f) / 20.0f + 1.0f;
                int fillAmount = Math.min(this.currentRecipe.fluid.getAmount(), resource.getAmount());
                float fillTime = (float)fillAmount / 1000.0f;
                this.setTicksPerWorkCycle(Math.round((fillTime *= viscosityMultiplier) * 5.0f));
                this.setEnergyPerWorkCycle(0);
            }
        }
    }

    @Override
    public void onTake(int slotIndex, PlayerEntity player) {
        if (slotIndex == 2) {
            if (this.currentRecipe != null && !this.currentRecipe.fillRecipe) {
                this.currentRecipe = null;
                this.setTicksPerWorkCycle(0);
            }
        } else if (slotIndex == 3 && this.currentRecipe != null && this.currentRecipe.fillRecipe) {
            this.currentRecipe = null;
            this.setTicksPerWorkCycle(0);
        }
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        super.writeGuiData(data);
        if (this.currentRecipe == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(this.currentRecipe.fillRecipe);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readGuiData(PacketBufferForestry data) throws IOException {
        super.readGuiData(data);
        this.isFillRecipe = data.readBoolean();
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack emptyCan = inventory.func_70301_a(3);
        if (emptyCan.func_190926_b()) {
            return false;
        }
        return (float)emptyCan.func_190916_E() / (float)emptyCan.func_77976_d() > percentage;
    }

    @Override
    public boolean hasWork() {
        IFluidTank tank;
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.clearErrors();
        this.checkEmptyRecipe();
        FluidHelper.FillStatus emptyStatus = this.currentRecipe != null ? ((tank = this.tankManager.getTank(0)) != null ? FluidHelper.drainContainers(this.tankManager, (IInventory)this, 2, 4, false) : FluidHelper.FillStatus.SUCCESS) : null;
        if (emptyStatus != FluidHelper.FillStatus.SUCCESS) {
            this.checkFillRecipe();
            if (this.currentRecipe == null) {
                return false;
            }
        } else {
            return true;
        }
        FluidHelper.FillStatus fillStatus = FluidHelper.fillContainers(this.tankManager, (IInventory)this, 3, 5, this.currentRecipe.fluid.getFluid(), false);
        if (fillStatus == FluidHelper.FillStatus.SUCCESS) {
            return true;
        }
        errorLogic.setCondition(fillStatus == FluidHelper.FillStatus.NO_FLUID, EnumErrorCode.NO_RESOURCE_LIQUID);
        errorLogic.setCondition(fillStatus == FluidHelper.FillStatus.NO_SPACE, EnumErrorCode.NO_SPACE_INVENTORY);
        errorLogic.setCondition(emptyStatus == FluidHelper.FillStatus.NO_SPACE_FLUID, EnumErrorCode.NO_SPACE_TANK);
        if (emptyStatus == FluidHelper.FillStatus.INVALID_INPUT || fillStatus == FluidHelper.FillStatus.INVALID_INPUT || errorLogic.hasErrors()) {
            this.currentRecipe = null;
            return false;
        }
        return true;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tankManager).cast();
        }
        return super.getCapability(capability, facing);
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerBottler(windowId, player.field_71071_by, this);
    }
}

