/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.fermenter;

import forestry.api.recipes.IFermenterRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.utils.Log;
import forestry.factory.recipes.jei.fermenter.FermenterRecipeWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.helpers.IStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;

public class FermenterRecipeMaker {
    public static List<FermenterRecipeWrapper> getFermenterRecipes(RecipeManager manager, IStackHelper stackHelper) {
        ArrayList<FermenterRecipeWrapper> recipes = new ArrayList<FermenterRecipeWrapper>();
        for (IFermenterRecipe recipe : RecipeManagers.fermenterManager.getRecipes(manager)) {
            if (recipe.getResource() != null) {
                FermenterRecipeMaker.addWrapperToList(stackHelper, recipe, recipe.getResource(), recipes);
                continue;
            }
            Log.error("Empty resource for recipe", new Object[0]);
        }
        return recipes;
    }

    private static void addWrapperToList(IStackHelper stackHelper, IFermenterRecipe recipe, Ingredient resource, List<FermenterRecipeWrapper> recipes) {
        Stream<ItemStack> itemStacks = Arrays.stream(resource.func_193365_a());
        itemStacks.forEach(stack -> recipes.add(new FermenterRecipeWrapper(recipe, (ItemStack)stack)));
    }
}

