/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.factory.recipes.RecipeSerializers;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SqueezerRecipe
implements ISqueezerRecipe {
    private final ResourceLocation id;
    private final int processingTime;
    private final NonNullList<Ingredient> resources;
    private final FluidStack fluidOutput;
    private final ItemStack remnants;
    private final float remnantsChance;

    public SqueezerRecipe(ResourceLocation id, int processingTime, NonNullList<Ingredient> resources, FluidStack fluidOutput, ItemStack remnants, float remnantsChance) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull(resources);
        Preconditions.checkArgument((!resources.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)fluidOutput);
        Preconditions.checkNotNull((Object)remnants);
        this.id = id;
        this.processingTime = processingTime;
        this.resources = resources;
        this.fluidOutput = fluidOutput;
        this.remnants = remnants;
        this.remnantsChance = remnantsChance;
    }

    @Override
    public NonNullList<Ingredient> getResources() {
        return this.resources;
    }

    @Override
    public ItemStack getRemnants() {
        return this.remnants;
    }

    @Override
    public float getRemnantsChance() {
        return this.remnantsChance;
    }

    @Override
    public FluidStack getFluidOutput() {
        return this.fluidOutput;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SqueezerRecipe> {
        public SqueezerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int processingTime = JSONUtils.func_151203_m((JsonObject)json, (String)"time");
            NonNullList resources = NonNullList.func_191196_a();
            FluidStack fluidOutput = RecipeSerializers.deserializeFluid(JSONUtils.func_152754_s((JsonObject)json, (String)"output"));
            ItemStack remnants = RecipeSerializers.item(JSONUtils.func_152754_s((JsonObject)json, (String)"remnant"));
            float remnantsChance = JSONUtils.func_151217_k((JsonObject)json, (String)"chance");
            for (JsonElement element : JSONUtils.func_151214_t((JsonObject)json, (String)"resources")) {
                resources.add((Object)RecipeSerializers.deserialize(element));
            }
            return new SqueezerRecipe(recipeId, processingTime, (NonNullList<Ingredient>)resources, fluidOutput, remnants, remnantsChance);
        }

        public SqueezerRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int processingTime = buffer.func_150792_a();
            NonNullList<Ingredient> resources = RecipeSerializers.read(buffer, Ingredient::func_199566_b);
            FluidStack fluidOutput = FluidStack.readFromPacket((PacketBuffer)buffer);
            ItemStack remnants = buffer.func_150791_c();
            float remnantsChance = buffer.readFloat();
            return new SqueezerRecipe(recipeId, processingTime, resources, fluidOutput, remnants, remnantsChance);
        }

        public void toNetwork(PacketBuffer buffer, SqueezerRecipe recipe) {
            buffer.func_150787_b(recipe.processingTime);
            RecipeSerializers.write(buffer, recipe.resources, (packetBuffer, ingredient) -> ingredient.func_199564_a(packetBuffer));
            recipe.fluidOutput.writeToPacket(buffer);
            buffer.func_150788_a(recipe.remnants);
            buffer.writeFloat(recipe.remnantsChance);
        }
    }
}

