/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import forestry.api.recipes.IFermenterRecipe;
import forestry.factory.recipes.RecipeSerializers;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FermenterRecipe
implements IFermenterRecipe {
    private final ResourceLocation id;
    private final Ingredient resource;
    private final int fermentationValue;
    private final float modifier;
    private final Fluid output;
    private final FluidStack fluidResource;

    public FermenterRecipe(ResourceLocation id, Ingredient resource, int fermentationValue, float modifier, Fluid output, FluidStack fluidResource) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull((Object)resource, (Object)"Fermenter Resource cannot be null!");
        Preconditions.checkArgument((!resource.func_203189_d() ? 1 : 0) != 0, (Object)"Fermenter Resource item cannot be empty!");
        Preconditions.checkNotNull((Object)output, (Object)"Fermenter Output cannot be null!");
        Preconditions.checkNotNull((Object)fluidResource, (Object)"Fermenter Liquid cannot be null!");
        this.id = id;
        this.resource = resource;
        this.fermentationValue = fermentationValue;
        this.modifier = modifier;
        this.output = output;
        this.fluidResource = fluidResource;
    }

    public FermenterRecipe(ResourceLocation id, int fermentationValue, float modifier, Fluid output, FluidStack fluidResource) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull((Object)output, (Object)"Fermenter output cannot be null!");
        Preconditions.checkNotNull((Object)fluidResource, (Object)"Fermenter liquid cannot be null!");
        this.id = id;
        this.resource = Ingredient.field_193370_a;
        this.fermentationValue = fermentationValue;
        this.modifier = modifier;
        this.output = output;
        this.fluidResource = fluidResource;
    }

    @Override
    public Ingredient getResource() {
        return this.resource;
    }

    @Override
    public FluidStack getFluidResource() {
        return this.fluidResource;
    }

    @Override
    public int getFermentationValue() {
        return this.fermentationValue;
    }

    @Override
    public float getModifier() {
        return this.modifier;
    }

    @Override
    public Fluid getOutput() {
        return this.output;
    }

    @Override
    public int compareTo(IFermenterRecipe o) {
        return !this.resource.func_203189_d() ? -1 : 1;
    }

    @Override
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<FermenterRecipe> {
        public FermenterRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient resource = RecipeSerializers.deserialize(json.get("resource"));
            int fermentationValue = JSONUtils.func_151203_m((JsonObject)json, (String)"fermentationValue");
            float modifier = JSONUtils.func_151217_k((JsonObject)json, (String)"modifier");
            Fluid output = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"output")));
            FluidStack fluidResource = RecipeSerializers.deserializeFluid(JSONUtils.func_152754_s((JsonObject)json, (String)"fluidResource"));
            return new FermenterRecipe(recipeId, resource, fermentationValue, modifier, output, fluidResource);
        }

        public FermenterRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient resource = Ingredient.func_199566_b((PacketBuffer)buffer);
            int fermentationValue = buffer.func_150792_a();
            float modifier = buffer.readFloat();
            Fluid output = (Fluid)ForgeRegistries.FLUIDS.getValue(buffer.func_192575_l());
            FluidStack fluidResource = FluidStack.readFromPacket((PacketBuffer)buffer);
            return new FermenterRecipe(recipeId, resource, fermentationValue, modifier, output, fluidResource);
        }

        public void toNetwork(PacketBuffer buffer, FermenterRecipe recipe) {
            recipe.resource.func_199564_a(buffer);
            buffer.func_150787_b(recipe.fermentationValue);
            buffer.writeFloat(recipe.modifier);
            buffer.func_192572_a(ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)recipe.output));
            recipe.fluidResource.writeToPacket(buffer);
        }
    }
}

