/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.factory.recipes.RecipeSerializers;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FabricatorSmeltingRecipe
implements IFabricatorSmeltingRecipe {
    private final ResourceLocation id;
    private final Ingredient resource;
    private final FluidStack product;
    private final int meltingPoint;

    public FabricatorSmeltingRecipe(ResourceLocation id, Ingredient resource, FluidStack molten, int meltingPoint) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull((Object)resource);
        Preconditions.checkArgument((!resource.func_203189_d() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)molten);
        this.id = id;
        this.resource = resource;
        this.product = molten;
        this.meltingPoint = meltingPoint;
    }

    @Override
    public Ingredient getResource() {
        return this.resource;
    }

    @Override
    public FluidStack getProduct() {
        return this.product;
    }

    @Override
    public int getMeltingPoint() {
        return this.meltingPoint;
    }

    @Override
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<FabricatorSmeltingRecipe> {
        public FabricatorSmeltingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient resource = RecipeSerializers.deserialize(json.get("resource"));
            FluidStack product = RecipeSerializers.deserializeFluid(JSONUtils.func_152754_s((JsonObject)json, (String)"product"));
            int meltingPoint = JSONUtils.func_151203_m((JsonObject)json, (String)"melting");
            return new FabricatorSmeltingRecipe(recipeId, resource, product, meltingPoint);
        }

        public FabricatorSmeltingRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient resource = Ingredient.func_199566_b((PacketBuffer)buffer);
            FluidStack product = FluidStack.readFromPacket((PacketBuffer)buffer);
            int meltingPoint = buffer.func_150792_a();
            return new FabricatorSmeltingRecipe(recipeId, resource, product, meltingPoint);
        }

        public void toNetwork(PacketBuffer buffer, FabricatorSmeltingRecipe recipe) {
            recipe.resource.func_199564_a(buffer);
            recipe.product.writeToPacket(buffer);
            buffer.func_150787_b(recipe.meltingPoint);
        }
    }
}

