/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.ICarpenterManager;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.recipes.AbstractCraftingProvider;
import forestry.factory.recipes.FakeCraftingInventory;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class CarpenterRecipeManager
extends AbstractCraftingProvider<ICarpenterRecipe>
implements ICarpenterManager {
    public CarpenterRecipeManager() {
        super(ICarpenterRecipe.TYPE);
    }

    @Override
    public void addRecipe(ItemStack box, ItemStack product, Object[] materials) {
        this.addRecipe(5, (FluidStack)null, box, product, materials);
    }

    @Override
    public void addRecipe(int packagingTime, ItemStack box, ItemStack product, Object[] materials) {
        this.addRecipe(packagingTime, (FluidStack)null, box, product, materials);
    }

    @Override
    public void addRecipe(int packagingTime, @Nullable FluidStack liquid, ItemStack box, ItemStack product, Object[] materials) {
    }

    @Override
    public Optional<ICarpenterRecipe> findMatchingRecipe(@Nullable RecipeManager recipeManager, FluidStack liquid, ItemStack item, IInventory inventory, World world) {
        for (ICarpenterRecipe recipe : this.getRecipes(recipeManager)) {
            if (!this.matches(recipe, liquid, item, inventory, world)) continue;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    @Override
    public boolean matches(@Nullable ICarpenterRecipe recipe, FluidStack resource, ItemStack item, IInventory craftingInventory, World world) {
        if (recipe == null) {
            return false;
        }
        FluidStack liquid = recipe.getFluidResource();
        if (!(liquid == null || liquid.isEmpty() || !resource.isEmpty() && resource.containsFluid(liquid))) {
            return false;
        }
        Ingredient box = recipe.getBox();
        if (!box.func_203189_d() && !box.test(item)) {
            return false;
        }
        ICraftingRecipe internal = recipe.getCraftingGridRecipe();
        return internal.func_77569_a((IInventory)FakeCraftingInventory.of(craftingInventory), world);
    }

    @Override
    public boolean isBox(@Nullable RecipeManager recipeManager, ItemStack resource) {
        if (resource.func_190926_b()) {
            return false;
        }
        for (ICarpenterRecipe recipe : this.getRecipes(recipeManager)) {
            Ingredient box = recipe.getBox();
            if (!box.test(resource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ICarpenterRecipe> getRecipesWithOutput(@Nullable RecipeManager recipeManager, ItemStack output) {
        if (output.func_190926_b()) {
            return Collections.emptyList();
        }
        return this.getRecipes(recipeManager).stream().filter(recipe -> {
            ItemStack o = recipe.getResult();
            return ItemStackUtil.isIdenticalItem(o, output);
        }).collect(Collectors.toList());
    }

    @Override
    public Set<ResourceLocation> getRecipeFluids(@Nullable RecipeManager recipeManager) {
        return this.getRecipes(recipeManager).stream().map(ICarpenterRecipe::getFluidResource).filter(fluidStack -> fluidStack != null && !fluidStack.isEmpty()).map(fluidStack -> fluidStack.getFluid().getRegistryName()).collect(Collectors.toSet());
    }
}

