/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.inventory;

import forestry.core.fluids.FluidHelper;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.factory.tiles.TileBottler;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class InventoryBottler
extends InventoryAdapterTile<TileBottler> {
    public static final short SLOT_INPUT_FULL_CONTAINER = 0;
    public static final short SLOT_INPUT_EMPTY_CONTAINER = 1;
    public static final short SLOT_EMPTYING_PROCESSING = 2;
    public static final short SLOT_FILLING_PROCESSING = 3;
    public static final short SLOT_OUTPUT_EMPTY_CONTAINER = 4;
    public static final short SLOT_OUTPUT_FULL_CONTAINER = 5;

    public InventoryBottler(TileBottler tileBottler) {
        super(tileBottler, 6, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 1) {
            return FluidHelper.isFillableContainerWithRoom(itemStack);
        }
        if (slotIndex == 0) {
            Optional fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack);
            return fluidStack.map(f -> ForgeRegistries.FLUIDS.containsValue((IForgeRegistryEntry)f.getFluid())).orElse(false);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack itemstack, Direction side) {
        return slotIndex == 4 || slotIndex == 5;
    }
}

