/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.widgets.TankWidget;
import forestry.core.render.ColourProperties;
import forestry.core.utils.Translator;
import forestry.factory.gui.ContainerBottler;
import forestry.factory.tiles.TileBottler;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiBottler
extends GuiForestryTitled<ContainerBottler> {
    private final TileBottler tile;

    public GuiBottler(ContainerBottler container, PlayerInventory inventory, ITextComponent title) {
        super("textures/gui/bottler.png", container, inventory, title);
        this.tile = (TileBottler)container.getTile();
        this.widgetManager.add(new TankWidget(this.widgetManager, 80, 14, 0));
    }

    @Override
    protected void func_230450_a_(MatrixStack transform, float partialTicks, int mouseY, int mouseX) {
        this.bindTexture(this.textureFile);
        int x = (this.field_230708_k_ - this.field_146999_f) / 2;
        int y = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(transform, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        RenderSystem.disableLighting();
        RenderSystem.enableRescaleNormal();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.drawWidgets(transform);
        RenderSystem.popMatrix();
        String name = Translator.translateToLocal(this.tile.getUnlocalizedTitle());
        this.textLayout.line = 5;
        this.textLayout.drawCenteredLine(transform, name, 0, ColourProperties.INSTANCE.get("gui.title"));
        this.bindTexture(this.textureFile);
        this.bindTexture(this.textureFile);
        TileBottler bottler = this.tile;
        int progressArrow = bottler.getProgressScaled(22);
        if (progressArrow > 0) {
            if (bottler.isFillRecipe) {
                this.func_238474_b_(transform, this.field_147003_i + 108, this.field_147009_r + 35, 177, 74, progressArrow, 16);
            } else {
                this.func_238474_b_(transform, this.field_147003_i + 46, this.field_147009_r + 35, 177, 74, progressArrow, 16);
            }
        }
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.tile);
        this.addHintLedger("bottler");
        this.addPowerLedger(this.tile.getEnergyManager());
    }
}

