/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import forestry.core.config.Config;
import forestry.energy.EnergyManager;
import forestry.energy.tiles.TileEngine;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyHelper {
    public static int scaleForDifficulty(int energyValue) {
        return Math.round((float)energyValue * 1.0f);
    }

    public static boolean consumeEnergyToDoWork(EnergyManager energyManager, int ticksPerWorkCycle, int energyPerWorkCycle) {
        if (energyPerWorkCycle == 0) {
            return true;
        }
        int energyPerCycle = (int)Math.ceil((float)energyPerWorkCycle / (float)ticksPerWorkCycle);
        if (energyManager.getEnergyStored() < energyPerCycle) {
            return false;
        }
        energyManager.drainEnergy(energyPerCycle);
        return true;
    }

    public static int sendEnergy(EnergyManager energyManager, Direction orientation, @Nullable TileEntity tile) {
        return EnergyHelper.sendEnergy(energyManager, orientation, tile, Integer.MAX_VALUE, false);
    }

    public static int sendEnergy(EnergyManager energyManager, Direction orientation, @Nullable TileEntity tile, int amount, boolean simulate) {
        int extractable = energyManager.extractEnergy(amount, true);
        if (extractable > 0) {
            Direction side = orientation.func_176734_d();
            int sent = EnergyHelper.sendEnergyToTile(tile, side, extractable, simulate);
            energyManager.extractEnergy(sent, simulate);
            return sent;
        }
        return 0;
    }

    private static int sendEnergyToTile(@Nullable TileEntity tile, Direction side, int extractable, boolean simulate) {
        LazyOptional energyStorage;
        if (tile == null) {
            return 0;
        }
        if (tile instanceof TileEngine) {
            TileEngine receptor = (TileEngine)tile;
            return receptor.getEnergyManager().receiveEnergy(extractable, simulate);
        }
        if (Config.enableRF && (energyStorage = tile.getCapability(CapabilityEnergy.ENERGY, side)).isPresent()) {
            return ((IEnergyStorage)energyStorage.orElse(null)).receiveEnergy(extractable, simulate);
        }
        return 0;
    }

    public static boolean canSendEnergy(EnergyManager energyManager, Direction orientation, TileEntity tile) {
        return EnergyHelper.sendEnergy(energyManager, orientation, tile, Integer.MAX_VALUE, true) > 0;
    }

    public static boolean isEnergyReceiverOrEngine(Direction side, @Nullable TileEntity tile) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof TileEngine) {
            return true;
        }
        LazyOptional energyStorage = tile.getCapability(CapabilityEnergy.ENERGY, side);
        if (energyStorage.isPresent()) {
            return ((IEnergyStorage)energyStorage.orElse(null)).canReceive();
        }
        return false;
    }
}

