/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.blocks;

import forestry.api.core.IBlockSubtype;
import forestry.core.blocks.BlockBase;
import forestry.core.render.ParticleRender;
import forestry.cultivation.blocks.BlockTypePlanter;
import forestry.cultivation.tiles.TilePlanter;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockPlanter
extends BlockBase<BlockTypePlanter> {
    private Mode mode;

    public BlockPlanter(BlockTypePlanter blockType, Mode mode) {
        super(blockType, Material.field_151575_d);
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.blockType == BlockTypePlanter.FARM_ENDER) {
            for (int i = 0; i < 3; ++i) {
                ParticleRender.addPortalFx(worldIn, pos, rand);
            }
        }
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        TileEntity tile = super.createTileEntity(state, world);
        if (tile instanceof TilePlanter) {
            TilePlanter planter = (TilePlanter)tile;
            planter.setManual(this.getMode());
        }
        return tile;
    }

    public static enum Mode implements IBlockSubtype
    {
        MANUAL,
        MANAGED;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

