/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import forestry.core.utils.Log;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.common.util.JsonUtils;

public class JsonUtil {
    private JsonUtil() {
    }

    public static ItemStack deserializeItemStack(JsonObject object, ItemStack fallback) {
        return JsonUtil.deserializeItemStack(object, fallback, false);
    }

    public static ItemStack deserializeItemStack(JsonObject object, ItemStack fallback, boolean logError) {
        if (!object.has("item")) {
            if (logError) {
                Log.error("Unsupported icon type, currently only items are supported (add 'item' key)", new Object[0]);
            }
            return fallback;
        }
        try {
            Item item = JSONUtils.func_188180_i((JsonObject)object, (String)"item");
            int count = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
            ItemStack stack = new ItemStack((IItemProvider)item, count);
            stack.func_77982_d(JsonUtils.readNBT((JsonObject)object, (String)"nbt"));
            return stack;
        }
        catch (JsonSyntaxException e) {
            if (logError) {
                Log.trace("Filed to parse item.", new Object[]{e});
            }
            return fallback;
        }
    }
}

