/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ItemStackUtil {
    private static final int[] EMPTY_CONSUME = new int[0];

    public static boolean isIdenticalItem(ItemStack lhs, ItemStack rhs) {
        return lhs.equals(rhs, false);
    }

    public static void mergeStacks(ItemStack giver, ItemStack receptor) {
        int maxInsert = receptor.func_77976_d() - receptor.func_190916_E();
        int maxExtract = giver.func_190916_E();
        int canTransfer = Math.min(maxInsert, maxExtract);
        giver.func_190918_g(canTransfer);
        receptor.func_190917_f(canTransfer);
    }

    public static NonNullList<ItemStack> condenseStacks(NonNullList<ItemStack> stacks) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (ItemStack stack : stacks) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            map.put((Object)copy, map.getInt((Object)copy) + stack.func_190916_E());
        }
        NonNullList condensed = NonNullList.func_191196_a();
        for (Object2IntMap.Entry entry : map.object2IntEntrySet()) {
            int transfer;
            ItemStack stack = (ItemStack)entry.getKey();
            for (int count = entry.getIntValue(); count > 0; count -= transfer) {
                transfer = Math.min(count, stack.func_77976_d());
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(transfer);
                condensed.add((Object)copy);
            }
        }
        return condensed;
    }

    public static boolean containsItemStack(Iterable<ItemStack> list, ItemStack itemStack) {
        for (ItemStack listStack : list) {
            if (!ItemStackUtil.isIdenticalItem(listStack, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static int[] createConsume(NonNullList<Ingredient> set, IInventory inventory, boolean craftingTools) {
        return ItemStackUtil.createConsume(set, inventory.func_70302_i_(), arg_0 -> ((IInventory)inventory).func_70301_a(arg_0), craftingTools);
    }

    public static int[] createConsume(NonNullList<Ingredient> set, int stockCount, Function<Integer, ItemStack> stock, boolean craftingTools) {
        int[] reqAmounts = new int[stockCount];
        int found = 0;
        block0: for (Ingredient ing : set) {
            if (ing.func_203189_d()) {
                ++found;
                continue;
            }
            for (ItemStack stack : ing.func_193365_a()) {
                int curFound = found;
                for (int i = 0; i < reqAmounts.length; ++i) {
                    ItemStack offer = stock.apply(i);
                    if (offer.func_190916_E() <= reqAmounts[i] || !ItemStackUtil.isCraftingEquivalent(stack, offer, craftingTools)) continue;
                    reqAmounts[i] = reqAmounts[i] + 1;
                    ++found;
                    break;
                }
                if (found > curFound) continue block0;
            }
        }
        if (found < set.size()) {
            return EMPTY_CONSUME;
        }
        return reqAmounts;
    }

    public static int containsSets(NonNullList<ItemStack> set, NonNullList<ItemStack> stock) {
        return ItemStackUtil.containsSets(set, stock, false);
    }

    public static int containsSets(NonNullList<ItemStack> set, NonNullList<ItemStack> stock, boolean craftingTools) {
        int totalSets = 0;
        NonNullList<ItemStack> condensedRequired = ItemStackUtil.condenseStacks(set);
        NonNullList<ItemStack> condensedOffered = ItemStackUtil.condenseStacks(stock);
        for (ItemStack req : condensedRequired) {
            int reqCount = 0;
            for (ItemStack offer : condensedOffered) {
                if (!ItemStackUtil.isCraftingEquivalent(req, offer, craftingTools)) continue;
                int stackCount = offer.func_190916_E() / req.func_190916_E();
                reqCount = Math.max(reqCount, stackCount);
            }
            if (reqCount == 0) {
                return 0;
            }
            if (totalSets == 0) {
                totalSets = reqCount;
                continue;
            }
            if (totalSets <= reqCount) continue;
            totalSets = reqCount;
        }
        return totalSets;
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison) {
        if (base.func_190926_b() || comparison.func_190926_b()) {
            return false;
        }
        if (base.func_77973_b() != comparison.func_77973_b()) {
            return false;
        }
        if (base.func_77978_p() == null || base.func_77978_p().isEmpty()) {
            return true;
        }
        return ItemStack.func_77970_a((ItemStack)base, (ItemStack)comparison);
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison, boolean craftingTools) {
        if (base.func_190926_b() || comparison.func_190926_b()) {
            return false;
        }
        if (craftingTools && ItemStackUtil.isCraftingToolEquivalent(base, comparison)) {
            return true;
        }
        return ItemStackUtil.isCraftingEquivalent(base, comparison);
    }

    public static boolean isCraftingToolEquivalent(ItemStack base, ItemStack comparison) {
        if (base.func_190926_b() || comparison.func_190926_b()) {
            return false;
        }
        Item baseItem = base.func_77973_b();
        if (baseItem != comparison.func_77973_b()) {
            return false;
        }
        return base.func_77978_p() == null || base.func_77978_p().isEmpty();
    }

    public static void dropItemStackAsEntity(ItemStack items, World world, double x, double y, double z) {
        ItemStackUtil.dropItemStackAsEntity(items, world, x, y, z, 10);
    }

    public static void dropItemStackAsEntity(ItemStack items, World world, BlockPos pos) {
        ItemStackUtil.dropItemStackAsEntity(items, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 10);
    }

    public static void dropItemStackAsEntity(ItemStack items, World world, double x, double y, double z, int delayForPickup) {
        if (items.func_190926_b() || world.field_72995_K) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        ItemEntity entityitem = new ItemEntity(world, x + d, y + d1, z + d2, items);
        entityitem.func_174867_a(delayForPickup);
        world.func_217376_c((Entity)entityitem);
    }

    public static ItemStack copyWithRandomSize(ItemStack template, int max, Random rand) {
        int size = max <= 0 ? 1 : rand.nextInt(max);
        ItemStack copy = template.func_77946_l();
        copy.func_190920_e(Math.min(size, template.func_77976_d()));
        return copy;
    }

    @Nullable
    public static Block getBlock(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof BlockItem) {
            return ((BlockItem)item).func_179223_d();
        }
        return null;
    }

    public static boolean equals(Block block, ItemStack stack) {
        return block == ItemStackUtil.getBlock(stack);
    }

    public static boolean areItemStacksEqualIgnoreCount(ItemStack a, ItemStack b) {
        int countB = b.func_190916_E();
        b.func_190920_e(a.func_190916_E());
        boolean equals = a.equals(b, false);
        b.func_190920_e(countB);
        return equals;
    }
}

