/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.genetics.IAlleleBeeSpecies;
import forestry.api.arboriculture.ArboricultureCapabilities;
import forestry.api.arboriculture.genetics.IAlleleTreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.core.IArmorNaturalist;
import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.IPollinatable;
import forestry.api.genetics.ISpeciesRootPollinatable;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.lepidopterology.genetics.IAlleleButterflySpecies;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.arboriculture.capabilities.ArmorNaturalist;
import forestry.core.genetics.ItemGE;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.Translator;
import genetics.api.GeneticHelper;
import genetics.api.GeneticsAPI;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IIndividual;
import genetics.api.mutation.IMutation;
import genetics.api.mutation.IMutationContainer;
import genetics.api.organism.IOrganismType;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.IRootDefinition;
import genetics.api.root.components.ComponentKeys;
import genetics.utils.AlleleUtils;
import genetics.utils.RootUtils;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class GeneticsUtil {
    private static String getKeyPrefix(IAllele allele) {
        if (allele instanceof IAlleleBeeSpecies) {
            return "for.bees";
        }
        if (allele instanceof IAlleleTreeSpecies) {
            return "for.trees";
        }
        if (allele instanceof IAlleleButterflySpecies) {
            return "for.butterflies";
        }
        throw new IllegalStateException();
    }

    public static ITextComponent getAlyzerName(IOrganismType type, IAlleleForestrySpecies allele) {
        String customKey = GeneticsUtil.getKeyPrefix(allele) + ".custom.alyzer." + type.getName() + '.' + allele.getSpeciesIdentifier();
        return Translator.tryTranslate(customKey, allele::getDisplayName);
    }

    public static ITextComponent getItemName(IOrganismType type, IAlleleForestrySpecies allele) {
        String prefix = GeneticsUtil.getKeyPrefix(allele);
        String customKey = prefix + ".custom." + type.getName() + '.' + allele.getSpeciesIdentifier();
        return Translator.tryTranslate(customKey, () -> {
            ITextComponent speciesName = allele.getDisplayName();
            TranslationTextComponent typeName = new TranslationTextComponent(prefix + ".grammar." + type.getName() + ".type");
            return new TranslationTextComponent(prefix + ".grammar." + type.getName(), new Object[]{speciesName, typeName});
        });
    }

    public static boolean hasNaturalistEye(PlayerEntity player) {
        ItemStack armorItemStack = player.func_184582_a(EquipmentSlotType.HEAD);
        if (armorItemStack.func_190926_b()) {
            return false;
        }
        LazyOptional armorCap = armorItemStack.getCapability(ArboricultureCapabilities.ARMOR_NATURALIST);
        if (!armorCap.isPresent()) {
            return false;
        }
        IArmorNaturalist armorNaturalist = (IArmorNaturalist)armorCap.orElse((Object)ArmorNaturalist.INSTANCE);
        return armorNaturalist.canSeePollination(player, armorItemStack, true);
    }

    public static boolean canNurse(IButterfly butterfly, World world, BlockPos pos) {
        IButterflyNursery tile = TileUtil.getTile((IBlockReader)world, pos, IButterflyNursery.class);
        return tile != null && tile.canNurse(butterfly);
    }

    @Nullable
    public static ICheckPollinatable getCheckPollinatable(World world, BlockPos pos) {
        IIndividual pollen;
        IIndividualRoot root;
        IPollinatable tile = TileUtil.getTile((IBlockReader)world, pos, IPollinatable.class);
        if (tile != null) {
            return tile;
        }
        Optional<IIndividual> optionalPollen = GeneticsUtil.getPollen((IWorld)world, pos);
        if (optionalPollen.isPresent() && (root = (pollen = optionalPollen.get()).getRoot()) instanceof ISpeciesRootPollinatable) {
            return ((ISpeciesRootPollinatable)root).createPollinatable(pollen);
        }
        return null;
    }

    @Nullable
    public static IPollinatable getOrCreatePollinatable(@Nullable GameProfile owner, World world, BlockPos pos, boolean convertVanilla) {
        IIndividual pollen;
        IIndividualRoot root;
        Optional<IIndividual> optionalPollen;
        IPollinatable pollinatable = TileUtil.getTile((IBlockReader)world, pos, IPollinatable.class);
        if (pollinatable == null && convertVanilla && (optionalPollen = GeneticsUtil.getPollen((IWorld)world, pos)).isPresent() && (root = (pollen = optionalPollen.get()).getRoot()) instanceof ISpeciesRootPollinatable) {
            ISpeciesRootPollinatable rootPollinatable = (ISpeciesRootPollinatable)root;
            pollinatable = rootPollinatable.tryConvertToPollinatable(owner, world, pos, pollen);
        }
        return pollinatable;
    }

    @Nullable
    public static IButterflyNursery getOrCreateNursery(@Nullable GameProfile gameProfile, IWorld world, BlockPos pos, boolean convertVanilla) {
        ITree treeLeave;
        IIndividual pollen;
        Optional<IIndividual> optionalPollen;
        IButterflyNursery nursery = GeneticsUtil.getNursery(world, pos);
        if (nursery == null && convertVanilla && (optionalPollen = GeneticsUtil.getPollen(world, pos)).isPresent() && (pollen = optionalPollen.get()) instanceof ITree && (treeLeave = (ITree)pollen).setLeaves(world, gameProfile, pos, world.func_201674_k())) {
            nursery = GeneticsUtil.getNursery(world, pos);
        }
        return nursery;
    }

    public static boolean canCreateNursery(IWorld world, BlockPos pos) {
        Optional<IIndividual> optional = GeneticsUtil.getPollen(world, pos);
        return optional.filter(pollen -> pollen instanceof ITree).isPresent();
    }

    @Nullable
    public static IButterflyNursery getNursery(IWorld world, BlockPos pos) {
        return TileUtil.getTile((IBlockReader)world, pos, IButterflyNursery.class);
    }

    public static Optional<IIndividual> getPollen(IWorld world, BlockPos pos) {
        if (!world.func_175667_e(pos)) {
            return Optional.empty();
        }
        ICheckPollinatable checkPollinatable = TileUtil.getTile((IBlockReader)world, pos, ICheckPollinatable.class);
        if (checkPollinatable != null) {
            return Optional.of(checkPollinatable.getPollen());
        }
        BlockState blockState = world.func_180495_p(pos);
        for (IRootDefinition definition : GeneticsAPI.apiInstance.getRoots().values()) {
            Object root = definition.cast();
            Optional<IIndividual> individual = root.translateMember(blockState);
            if (!individual.isPresent()) continue;
            return individual;
        }
        return Optional.empty();
    }

    public static <I extends IIndividual> Optional<I> getGeneticEquivalent(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemGE) {
            return GeneticHelper.getIndividual(itemStack);
        }
        for (IRootDefinition definition : GeneticsAPI.apiInstance.getRoots().values()) {
            Object root;
            Optional individual;
            if (!definition.isPresent() || !(individual = (root = definition.cast()).translateMember(itemStack)).isPresent()) continue;
            return individual;
        }
        return Optional.empty();
    }

    public static ItemStack convertToGeneticEquivalent(ItemStack foreign) {
        if (!RootUtils.hasRoot(foreign)) {
            Optional optionalIndividual = GeneticsUtil.getGeneticEquivalent(foreign);
            return optionalIndividual.map(individual -> {
                Object root = individual.getRoot().cast();
                Optional<IOrganismType> type = root.getType(foreign);
                if (type.isPresent()) {
                    ItemStack equivalent = root.createStack((IIndividual)individual, type.get());
                    equivalent.func_190920_e(foreign.func_190916_E());
                    return equivalent;
                }
                return null;
            }).orElse(foreign);
        }
        return foreign;
    }

    public static int getResearchComplexity(IAlleleSpecies species, IChromosomeType speciesChromosome) {
        return 1 + GeneticsUtil.getGeneticAdvancement(species, new HashSet<IAlleleSpecies>(), speciesChromosome);
    }

    private static int getGeneticAdvancement(IAlleleSpecies species, Set<IAlleleSpecies> exclude, IChromosomeType speciesChromosome) {
        int highest = 0;
        exclude.add(species);
        Object root = species.getRoot().cast();
        IMutationContainer container = (IMutationContainer)root.getComponent(ComponentKeys.MUTATIONS);
        for (IMutation mutation : container.getPaths(species, speciesChromosome)) {
            highest = GeneticsUtil.getHighestAdvancement(mutation.getFirstParent(), highest, exclude, speciesChromosome);
            highest = GeneticsUtil.getHighestAdvancement(mutation.getSecondParent(), highest, exclude, speciesChromosome);
        }
        return 1 + highest;
    }

    private static int getHighestAdvancement(IAlleleSpecies mutationSpecies, int highest, Set<IAlleleSpecies> exclude, IChromosomeType speciesChromosome) {
        if (exclude.contains(mutationSpecies) || AlleleUtils.isBlacklisted(mutationSpecies.getRegistryName().toString())) {
            return highest;
        }
        int otherAdvance = GeneticsUtil.getGeneticAdvancement(mutationSpecies, exclude, speciesChromosome);
        return Math.max(otherAdvance, highest);
    }
}

