/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.network.packets.PacketFXSignal;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.NetworkUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public abstract class BlockUtil {
    public static boolean alwaysTrue(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public static boolean alwaysFalse(BlockState state, IBlockReader reader, BlockPos pos) {
        return false;
    }

    public static List<ItemStack> getBlockDrops(IWorld world, BlockPos posBlock) {
        BlockState blockState = world.func_180495_p(posBlock);
        blockState.func_177230_c();
        return Block.func_220070_a((BlockState)blockState, (ServerWorld)((ServerWorld)world), (BlockPos)posBlock, (TileEntity)TileUtil.getTile((IBlockReader)world, posBlock));
    }

    public static boolean tryPlantCocoaPod(IWorld world, BlockPos pos) {
        Direction facing = BlockUtil.getValidPodFacing(world, pos, (ITag<Block>)BlockTags.field_203289_r);
        if (facing == null) {
            return false;
        }
        BlockState state = (BlockState)Blocks.field_150375_by.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)facing);
        world.func_180501_a(pos, state, 18);
        return true;
    }

    @Nullable
    public static Direction getValidPodFacing(IWorld world, BlockPos pos, ITag<Block> logTag) {
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            if (!BlockUtil.isValidPodLocation((IWorldReader)world, pos, facing, logTag)) continue;
            return facing;
        }
        return null;
    }

    public static boolean isValidPodLocation(IWorldReader world, BlockPos pos, Direction direction, ITag<Block> logTag) {
        if (!world.func_175667_e(pos = pos.func_177972_a(direction))) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block.func_203417_a(logTag);
    }

    public static boolean isBreakableBlock(World world, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        return BlockUtil.isBreakableBlock(blockState, world, pos);
    }

    public static boolean isBreakableBlock(BlockState blockState, World world, BlockPos pos) {
        return blockState.func_185887_b((IBlockReader)world, pos) >= 0.0f;
    }

    public static boolean isReplaceableBlock(BlockState blockState, World world, BlockPos pos) {
        Block block = blockState.func_177230_c();
        return world.func_180495_p(pos).func_185904_a().func_76222_j();
    }

    @Nullable
    public static RayTraceResult collisionRayTrace(BlockPos pos, Vector3d startVec, Vector3d endVec, AxisAlignedBB bounds) {
        return BlockUtil.collisionRayTrace(pos, startVec, endVec, bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c, bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f);
    }

    @Nullable
    public static RayTraceResult collisionRayTrace(BlockPos pos, Vector3d startVec, Vector3d endVec, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        startVec = startVec.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        endVec = endVec.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        Vector3d vec32 = startVec;
        Vector3d vec33 = startVec;
        Vector3d vec34 = startVec;
        Vector3d vec35 = startVec;
        Vector3d vec36 = startVec;
        Vector3d vec37 = startVec;
        if (!BlockUtil.isVecInsideYZBounds(vec32, minY, minZ, maxY, maxZ)) {
            vec32 = null;
        }
        if (!BlockUtil.isVecInsideYZBounds(vec33, minY, minZ, maxY, maxZ)) {
            vec33 = null;
        }
        if (!BlockUtil.isVecInsideXZBounds(vec34, minX, minZ, maxX, maxZ)) {
            vec34 = null;
        }
        if (!BlockUtil.isVecInsideXZBounds(vec35, minX, minZ, maxX, maxZ)) {
            vec35 = null;
        }
        if (!BlockUtil.isVecInsideXYBounds(vec36, minX, minY, maxX, maxY)) {
            vec36 = null;
        }
        if (!BlockUtil.isVecInsideXYBounds(vec37, minX, minY, maxX, maxY)) {
            vec37 = null;
        }
        Vector3d minHit = null;
        if (vec32 != null) {
            minHit = vec32;
        }
        if (vec33 != null && (minHit == null || startVec.func_72436_e(vec33) < startVec.func_72436_e(minHit))) {
            minHit = vec33;
        }
        if (vec34 != null && (minHit == null || startVec.func_72436_e(vec34) < startVec.func_72436_e(minHit))) {
            minHit = vec34;
        }
        if (vec35 != null && (minHit == null || startVec.func_72436_e(vec35) < startVec.func_72436_e(minHit))) {
            minHit = vec35;
        }
        if (vec36 != null && (minHit == null || startVec.func_72436_e(vec36) < startVec.func_72436_e(minHit))) {
            minHit = vec36;
        }
        if (vec37 != null && (minHit == null || startVec.func_72436_e(vec37) < startVec.func_72436_e(minHit))) {
            minHit = vec37;
        }
        if (minHit == null) {
            return null;
        }
        int sideHit = -1;
        if (minHit == vec32) {
            sideHit = 4;
        }
        if (minHit == vec33) {
            sideHit = 5;
        }
        if (minHit == vec34) {
            sideHit = 0;
        }
        if (minHit == vec35) {
            sideHit = 1;
        }
        if (minHit == vec36) {
            sideHit = 2;
        }
        if (minHit == vec37) {
            sideHit = 3;
        }
        return new BlockRayTraceResult(minHit.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), Direction.values()[sideHit], pos, true);
    }

    private static boolean isVecInsideYZBounds(@Nullable Vector3d vec, double minY, double minZ, double maxY, double maxZ) {
        return vec != null && vec.field_72448_b >= minY && vec.field_72448_b <= maxY && vec.field_72449_c >= minZ && vec.field_72449_c <= maxZ;
    }

    private static boolean isVecInsideXZBounds(@Nullable Vector3d vec, double minX, double minZ, double maxX, double maxZ) {
        return vec != null && vec.field_72450_a >= minX && vec.field_72450_a <= maxX && vec.field_72449_c >= minZ && vec.field_72449_c <= maxZ;
    }

    private static boolean isVecInsideXYBounds(@Nullable Vector3d vec, double minX, double minY, double maxX, double maxY) {
        return vec != null && vec.field_72450_a >= minX && vec.field_72450_a <= maxX && vec.field_72448_b >= minY && vec.field_72448_b <= maxY;
    }

    public static boolean canReplace(BlockState blockState, IWorld world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a().func_76222_j() && !blockState.func_185904_a().func_76224_d();
    }

    public static boolean canPlaceTree(BlockState blockState, IWorld world, BlockPos pos) {
        BlockPos downPos = pos.func_177977_b();
        Block block = world.func_180495_p(downPos).func_177230_c();
        return !world.func_180495_p(pos).func_185904_a().func_76222_j() || !blockState.func_185904_a().func_76224_d();
    }

    public static BlockPos getNextReplaceableUpPos(World world, BlockPos pos) {
        BlockPos topPos = world.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, pos);
        BlockPos.Mutable newPos = new BlockPos.Mutable();
        BlockState blockState = world.func_180495_p((BlockPos)newPos.func_189533_g((Vector3i)pos));
        while (!BlockUtil.canReplace(blockState, (IWorld)world, (BlockPos)newPos)) {
            newPos.func_189536_c(Direction.UP);
            if (newPos.func_177956_o() > topPos.func_177956_o()) {
                return null;
            }
            blockState = world.func_180495_p((BlockPos)newPos);
        }
        return newPos.func_177977_b();
    }

    @Nullable
    public static BlockPos getNextSolidDownPos(World world, BlockPos pos) {
        BlockPos.Mutable newPos = new BlockPos.Mutable();
        BlockState blockState = world.func_180495_p((BlockPos)newPos.func_189533_g((Vector3i)pos));
        while (BlockUtil.canReplace(blockState, (IWorld)world, (BlockPos)newPos)) {
            newPos.func_189536_c(Direction.DOWN);
            if (newPos.func_177956_o() <= 0) {
                return null;
            }
            blockState = world.func_180495_p((BlockPos)newPos);
        }
        return newPos.func_177984_a();
    }

    public static boolean setBlockWithPlaceSound(World world, BlockPos pos, BlockState blockState) {
        if (world.func_175656_a(pos, blockState)) {
            PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.SoundFXType.BLOCK_PLACE, pos, blockState);
            NetworkUtil.sendNetworkPacket(packet, pos, world);
            return true;
        }
        return false;
    }

    public static boolean setBlockWithBreakSound(World world, BlockPos pos, BlockState blockState, BlockState oldState) {
        if (world.func_175656_a(pos, blockState)) {
            PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, oldState);
            NetworkUtil.sendNetworkPacket(packet, pos, world);
            return true;
        }
        return false;
    }

    public static boolean setBlockToAirWithSound(World world, BlockPos pos, BlockState oldState) {
        if (world.func_217377_a(pos, false)) {
            PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, oldState);
            NetworkUtil.sendNetworkPacket(packet, pos, world);
            return true;
        }
        return false;
    }
}

