/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.blocks.BlockBase;
import forestry.core.render.ForestryResource;
import forestry.core.render.IForestryRenderer;
import forestry.core.render.RenderHelper;
import forestry.core.tiles.TileEscritoire;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class RenderEscritoire
implements IForestryRenderer<TileEscritoire> {
    private static final ResourceLocation TEXTURE = new ForestryResource("textures/block/escritoire.png");
    private final ModelRenderer desk;
    private final ModelRenderer standRB;
    private final ModelRenderer standRF;
    private final ModelRenderer standLB;
    private final ModelRenderer standLF;
    private final ModelRenderer drawers;
    private final ModelRenderer standLowLF;
    private final ModelRenderer standLowRB;
    private final ModelRenderer standLowRF;
    private final ModelRenderer standLowLB;

    public RenderEscritoire() {
        int textureWidth = 64;
        int textureHeight = 32;
        this.desk = new ModelRenderer(textureWidth, textureHeight, 0, 0);
        this.desk.func_228300_a_(-8.0f, 3.0f, -7.8f, 16.0f, 2.0f, 15.0f);
        this.desk.func_78793_a(0.0f, 0.0f, 0.0f);
        this.desk.func_78787_b(64, 32);
        this.desk.field_78809_i = true;
        RenderEscritoire.setRotation(this.desk, 0.0872665f, 0.0f, 0.0f);
        this.standRB = new ModelRenderer(textureWidth, textureHeight, 38, 18);
        this.standRB.func_228300_a_(5.0f, 4.0f, 5.0f, 2.0f, 6.0f, 2.0f);
        this.standRB.func_78793_a(0.0f, 0.0f, 0.0f);
        this.standRB.func_78787_b(64, 32);
        this.standRB.field_78809_i = true;
        RenderEscritoire.setRotation(this.standRB, 0.0f, 0.0f, 0.0f);
        this.standRF = new ModelRenderer(textureWidth, textureHeight, 38, 18);
        this.standRF.func_228300_a_(5.0f, 4.0f, -7.0f, 2.0f, 6.0f, 2.0f);
        this.standRF.func_78793_a(0.0f, 0.0f, 0.0f);
        this.standRF.func_78787_b(64, 32);
        this.standRF.field_78809_i = true;
        RenderEscritoire.setRotation(this.standRF, 0.0f, 0.0f, 0.0f);
        this.standLB = new ModelRenderer(textureWidth, textureHeight, 38, 18);
        this.standLB.func_228300_a_(-7.0f, 4.0f, 5.0f, 2.0f, 6.0f, 2.0f);
        this.standLB.func_78793_a(0.0f, 0.0f, 0.0f);
        this.standLB.func_78787_b(64, 32);
        this.standLB.field_78809_i = true;
        RenderEscritoire.setRotation(this.standLB, 0.0f, 0.0f, 0.0f);
        this.standLF = new ModelRenderer(textureWidth, textureHeight, 38, 18);
        this.standLF.func_228300_a_(-7.0f, 4.0f, -7.0f, 2.0f, 6.0f, 2.0f);
        this.standLF.func_78793_a(0.0f, 0.0f, 0.0f);
        this.standLF.func_78787_b(64, 32);
        this.standLF.field_78809_i = true;
        RenderEscritoire.setRotation(this.standLF, 0.0f, 0.0f, 0.0f);
        this.drawers = new ModelRenderer(textureWidth, textureHeight, 0, 18);
        this.drawers.func_228300_a_(-7.5f, -2.0f, 4.5f, 15.0f, 5.0f, 3.0f);
        this.drawers.func_78793_a(0.0f, 0.0f, 0.0f);
        this.drawers.func_78787_b(64, 32);
        this.drawers.field_78809_i = true;
        RenderEscritoire.setRotation(this.drawers, 0.0f, 0.0f, 0.0f);
        this.standLowLF = new ModelRenderer(textureWidth, textureHeight, 0, 26);
        this.standLowLF.func_228300_a_(-6.5f, 10.0f, -6.5f, 1.0f, 4.0f, 1.0f);
        this.standLowLF.func_78793_a(0.0f, 0.0f, 0.0f);
        this.standLowLF.func_78787_b(64, 32);
        this.standLowLF.field_78809_i = true;
        RenderEscritoire.setRotation(this.standLowLF, 0.0f, 0.0f, 0.0f);
        this.standLowRB = new ModelRenderer(textureWidth, textureHeight, 0, 26);
        this.standLowRB.func_228300_a_(5.5f, 10.0f, 5.5f, 1.0f, 4.0f, 1.0f);
        this.standLowRB.func_78793_a(0.0f, 0.0f, 0.0f);
        this.standLowRB.func_78787_b(64, 32);
        this.standLowRB.field_78809_i = true;
        RenderEscritoire.setRotation(this.standLowRB, 0.0f, 0.0f, 0.0f);
        this.standLowRF = new ModelRenderer(textureWidth, textureHeight, 0, 26);
        this.standLowRF.func_228300_a_(5.5f, 10.0f, -6.5f, 1.0f, 4.0f, 1.0f);
        this.standLowRF.func_78793_a(0.0f, 0.0f, 0.0f);
        this.standLowRF.func_78787_b(64, 32);
        this.standLowRF.field_78809_i = true;
        RenderEscritoire.setRotation(this.standLowRF, 0.0f, 0.0f, 0.0f);
        this.standLowLB = new ModelRenderer(textureWidth, textureHeight, 0, 26);
        this.standLowLB.func_228300_a_(-6.5f, 10.0f, 5.5f, 1.0f, 4.0f, 1.0f);
        this.standLowLB.func_78793_a(0.0f, 0.0f, 0.0f);
        this.standLowLB.func_78787_b(64, 32);
        this.standLowLB.field_78809_i = true;
        RenderEscritoire.setRotation(this.standLowLB, 0.0f, 0.0f, 0.0f);
    }

    private static void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    @Override
    public void renderTile(TileEscritoire tile, RenderHelper helper) {
        World world = tile.getWorldObj();
        BlockState blockState = world.func_180495_p(tile.func_174877_v());
        if (blockState.func_177230_c() instanceof BlockBase) {
            Direction facing = (Direction)blockState.func_177229_b(BlockBase.FACING);
            this.render(tile.getIndividualOnDisplay(), world, facing, helper);
        }
    }

    @Override
    public void renderItem(ItemStack stack, RenderHelper helper) {
        this.render(ItemStack.field_190927_a, null, Direction.SOUTH, helper);
    }

    private void render(ItemStack itemstack, @Nullable World world, Direction orientation, RenderHelper helper) {
        helper.push();
        helper.translate(0.5, 0.875, 0.5);
        Vector3f rotation = new Vector3f((float)Math.PI, 0.0f, 0.0f);
        switch (orientation) {
            case EAST: {
                rotation.setY(1.5707964f);
                break;
            }
            case SOUTH: {
                break;
            }
            case NORTH: {
                rotation.setY((float)Math.PI);
                break;
            }
            default: {
                rotation.setY(-1.5707964f);
            }
        }
        helper.setRotation(rotation);
        helper.renderModel(TEXTURE, new Vector3f(0.0872665f, 0.0f, 0.0f), this.desk);
        helper.renderModel(TEXTURE, this.standRB, this.standRF, this.standLB, this.standLF, this.drawers, this.standLowLF, this.standLowRB, this.standLowRF, this.standLowLB);
        helper.pop();
        if (!itemstack.func_190926_b() && world != null) {
            float renderScale = 0.75f;
            helper.push();
            helper.translate(0.5, 0.6f, 0.5);
            helper.scale(renderScale, renderScale, renderScale);
            helper.renderItem(itemstack, world);
            helper.pop();
        }
    }
}

