/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ParticleHelper {
    @OnlyIn(value=Dist.CLIENT)
    public static boolean addBlockHitEffects(World world, BlockPos pos, Direction side, ParticleManager effectRenderer, Callback callback) {
        BlockState blockState = world.func_180495_p(pos);
        if (blockState.func_185901_i() != BlockRenderType.INVISIBLE) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            float f = 0.1f;
            AxisAlignedBB axisalignedbb = blockState.func_196954_c((IBlockReader)world, pos).func_197752_a();
            double px = (double)x + world.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)(f * 2.0f)) + (double)f + axisalignedbb.field_72340_a;
            double py = (double)y + world.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)(f * 2.0f)) + (double)f + axisalignedbb.field_72338_b;
            double pz = (double)z + world.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)(f * 2.0f)) + (double)f + axisalignedbb.field_72339_c;
            if (side == Direction.DOWN) {
                py = (double)y + axisalignedbb.field_72338_b - (double)f;
            }
            if (side == Direction.UP) {
                py = (double)y + axisalignedbb.field_72337_e + (double)f;
            }
            if (side == Direction.NORTH) {
                pz = (double)z + axisalignedbb.field_72339_c - (double)f;
            }
            if (side == Direction.SOUTH) {
                pz = (double)z + axisalignedbb.field_72334_f + (double)f;
            }
            if (side == Direction.WEST) {
                px = (double)x + axisalignedbb.field_72340_a - (double)f;
            }
            if (side == Direction.EAST) {
                px = (double)x + axisalignedbb.field_72336_d + (double)f;
            }
            DiggingParticle fx = new DiggingParticle(WorldUtils.asClient((IWorld)world), px, py, pz, 0.0, 0.0, 0.0, blockState);
            effectRenderer.func_78873_a((Particle)fx);
            callback.addHitEffects(fx, world, pos, blockState);
            fx.func_174846_a(new BlockPos(x, y, z)).func_70543_e(0.2f).func_70541_f(0.6f);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean addDestroyEffects(World world, Block block, BlockState state, BlockPos pos, ParticleManager effectRenderer, Callback callback) {
        if (block != state.func_177230_c()) {
            return false;
        }
        int iterations = 4;
        for (int i = 0; i < iterations; ++i) {
            for (int j = 0; j < iterations; ++j) {
                for (int k = 0; k < iterations; ++k) {
                    double px = (double)pos.func_177958_n() + ((double)i + 0.5) / (double)iterations;
                    double py = (double)pos.func_177956_o() + ((double)j + 0.5) / (double)iterations;
                    double d = (double)pos.func_177952_p() + ((double)k + 0.5) / (double)iterations;
                }
            }
        }
        return true;
    }

    public static class DefaultCallback<B extends Block>
    implements Callback {
        protected final B block;

        public DefaultCallback(B block) {
            this.block = block;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void addHitEffects(DiggingParticle fx, World world, BlockPos pos, BlockState state) {
            this.setTexture(fx, world, pos, state);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void addDestroyEffects(DiggingParticle fx, World world, BlockPos pos, BlockState state) {
            this.setTexture(fx, world, pos, state);
        }

        @OnlyIn(value=Dist.CLIENT)
        protected void setTexture(DiggingParticle fx, World world, BlockPos pos, BlockState state) {
            Minecraft minecraft = Minecraft.func_71410_x();
            BlockRendererDispatcher blockRendererDispatcher = minecraft.func_175602_ab();
            BlockModelShapes blockModelShapes = blockRendererDispatcher.func_175023_a();
        }
    }

    public static interface Callback {
        @OnlyIn(value=Dist.CLIENT)
        public void addHitEffects(DiggingParticle var1, World var2, BlockPos var3, BlockState var4);

        @OnlyIn(value=Dist.CLIENT)
        public void addDestroyEffects(DiggingParticle var1, World var2, BlockPos var3, BlockState var4);
    }
}

