/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes.jei;

import com.google.common.collect.ArrayListMultimap;
import java.text.NumberFormat;
import java.util.List;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ForestryTooltipCallback
implements ITooltipCallback<ItemStack> {
    private final ArrayListMultimap<Integer, ITextComponent> tooltips = ArrayListMultimap.create();

    public void onTooltip(int index, boolean input, ItemStack ingredient, List<ITextComponent> tooltip) {
        List tip = this.tooltips.get((Object)index);
        if (!tip.isEmpty()) {
            tooltip.addAll(tip);
        }
    }

    public void addFortuneTooltip(int index) {
        this.tooltips.get((Object)index).add(new TranslationTextComponent("for.jei.fortune").func_240699_a_(TextFormatting.GRAY));
    }

    public void addChanceTooltip(int index, float chance) {
        if (chance < 0.0f) {
            chance = 0.0f;
        } else if ((double)chance > 1.0) {
            chance = 1.0f;
        }
        NumberFormat percentFormat = NumberFormat.getPercentInstance();
        percentFormat.setMaximumFractionDigits(2);
        String chanceString = String.valueOf(percentFormat.format(chance));
        this.tooltips.get((Object)index).add(new TranslationTextComponent("for.jei.chance", new Object[]{chanceString}).func_240699_a_(TextFormatting.GRAY));
    }
}

