/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.api.core.ForestryAPI;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ModuleCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("forestry", "module");
    private ResourceLocation module;

    public ModuleCondition(ResourceLocation module) {
        this.module = module;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        return ForestryAPI.enabledModules.contains(this.module);
    }

    public static class Serializer
    implements IConditionSerializer<ModuleCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, ModuleCondition value) {
            json.addProperty("module", value.module.toString());
        }

        public ModuleCondition read(JsonObject json) {
            String module = json.get("module").getAsString();
            JsonElement conElement = json.get("container");
            String container = conElement == null ? "forestry" : conElement.getAsString();
            return new ModuleCondition(new ResourceLocation(container, module));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

