/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import forestry.api.recipes.IHygroregulatorRecipe;
import forestry.factory.recipes.RecipeSerializers;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class HygroregulatorRecipe
implements IHygroregulatorRecipe {
    private final ResourceLocation id;
    private final FluidStack liquid;
    private final int transferTime;
    private final float humidChange;
    private final float tempChange;

    public HygroregulatorRecipe(ResourceLocation id, FluidStack liquid, int transferTime, float humidChange, float tempChange) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull((Object)liquid);
        Preconditions.checkArgument((transferTime > 0 ? 1 : 0) != 0);
        this.id = id;
        this.liquid = liquid;
        this.transferTime = transferTime;
        this.humidChange = humidChange;
        this.tempChange = tempChange;
    }

    @Override
    public FluidStack getResource() {
        return this.liquid;
    }

    @Override
    public int getTransferTime() {
        return this.transferTime;
    }

    @Override
    public float getHumidChange() {
        return this.humidChange;
    }

    @Override
    public float getTempChange() {
        return this.tempChange;
    }

    @Override
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<HygroregulatorRecipe> {
        public HygroregulatorRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            FluidStack liquid = RecipeSerializers.deserializeFluid(JSONUtils.func_152754_s((JsonObject)json, (String)"liquid"));
            int transferTime = JSONUtils.func_151203_m((JsonObject)json, (String)"time");
            float humidChange = JSONUtils.func_151217_k((JsonObject)json, (String)"humidChange");
            float tempChange = JSONUtils.func_151217_k((JsonObject)json, (String)"tempChange");
            return new HygroregulatorRecipe(recipeId, liquid, transferTime, humidChange, tempChange);
        }

        public HygroregulatorRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            FluidStack liquid = FluidStack.readFromPacket((PacketBuffer)buffer);
            int transferTime = buffer.func_150792_a();
            float humidChange = buffer.readFloat();
            float tempChange = buffer.readFloat();
            return new HygroregulatorRecipe(recipeId, liquid, transferTime, humidChange, tempChange);
        }

        public void toNetwork(PacketBuffer buffer, HygroregulatorRecipe recipe) {
            recipe.liquid.writeToPacket(buffer);
            buffer.func_150787_b(recipe.transferTime);
            buffer.writeFloat(recipe.humidChange);
            buffer.writeFloat(recipe.tempChange);
        }
    }
}

