/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.proxy;

import forestry.core.blocks.IBlockType;
import forestry.core.blocks.IMachineProperties;
import forestry.core.blocks.IMachinePropertiesTesr;
import forestry.core.blocks.MachinePropertiesTesr;
import forestry.core.features.CoreBlocks;
import forestry.core.fluids.ForestryFluids;
import forestry.core.items.definitions.EnumContainerType;
import forestry.core.models.ClientManager;
import forestry.core.models.FluidContainerModel;
import forestry.core.proxy.ProxyRender;
import forestry.core.render.RenderAnalyzer;
import forestry.core.render.RenderEscritoire;
import forestry.core.render.RenderForestryItem;
import forestry.core.render.RenderMachine;
import forestry.core.render.RenderMill;
import forestry.core.render.RenderNaturalistChest;
import forestry.core.tiles.TileAnalyzer;
import forestry.core.tiles.TileBase;
import forestry.core.tiles.TileEscritoire;
import forestry.core.tiles.TileMill;
import forestry.core.tiles.TileNaturalistChest;
import forestry.modules.IClientModuleHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ProxyRenderClient
extends ProxyRender
implements IClientModuleHandler {
    @Override
    public boolean fancyGraphicsEnabled() {
        return Minecraft.func_71410_x().field_71474_y.field_238330_f_ == GraphicsFanciness.FANCY;
    }

    @Override
    public void setupClient(FMLClientSetupEvent event) {
        for (EnumContainerType enumContainerType : EnumContainerType.values()) {
            ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation("forestry:" + enumContainerType.func_176610_l() + "_empty", "inventory"));
            ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation("forestry:" + enumContainerType.func_176610_l() + "_filled", "inventory"));
        }
        CoreBlocks.BASE.getBlocks().forEach(block -> RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228641_d_()));
        for (Enum enum_ : ForestryFluids.values()) {
            RenderTypeLookup.setRenderLayer((Fluid)((ForestryFluids)enum_).getFluid(), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)((ForestryFluids)enum_).getFlowing(), (RenderType)RenderType.func_228645_f_());
        }
    }

    @Override
    public void registerModels(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("forestry", "fluid_container"), (IModelLoader)new FluidContainerModel.Loader());
    }

    @Override
    public void bakeModels(ModelBakeEvent event) {
        ClientManager.getInstance().onBakeModels(event);
    }

    @Override
    public void setRenderDefaultMachine(MachinePropertiesTesr<? extends TileBase> machineProperties, String baseTexture) {
        machineProperties.setRenderer(new RenderMachine(baseTexture));
    }

    @Override
    public void setRenderMill(MachinePropertiesTesr<? extends TileMill> machineProperties, String baseTexture) {
        machineProperties.setRenderer(new RenderMill(baseTexture));
    }

    @Override
    public void setRenderEscritoire(MachinePropertiesTesr<? extends TileEscritoire> machineProperties) {
        machineProperties.setRenderer(new RenderEscritoire());
    }

    @Override
    public void setRendererAnalyzer(MachinePropertiesTesr<? extends TileAnalyzer> machineProperties) {
        RenderAnalyzer renderAnalyzer = new RenderAnalyzer();
        machineProperties.setRenderer(renderAnalyzer);
    }

    @Override
    public void setRenderChest(MachinePropertiesTesr<? extends TileNaturalistChest> machineProperties, String textureName) {
        machineProperties.setRenderer(new RenderNaturalistChest(textureName));
    }

    @Override
    public void registerItemAndBlockColors() {
        ClientManager.getInstance().registerItemAndBlockColors();
    }

    @Override
    public void setRenderer(Item.Properties properties, IBlockType type) {
        IMachineProperties<?> machineProperties = type.getMachineProperties();
        if (!(machineProperties instanceof IMachinePropertiesTesr)) {
            return;
        }
        IMachinePropertiesTesr machinePropertiesTesr = (IMachinePropertiesTesr)machineProperties;
        if (machinePropertiesTesr.getRenderer() == null) {
            return;
        }
        properties.setISTER(() -> () -> new RenderForestryItem(machinePropertiesTesr.getRenderer()));
    }
}

