/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.patchouli.component;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;

public class FluidComponent
implements ICustomComponent {
    public IVariable fluid;
    public IVariable amount;
    public IVariable max;
    public IVariable width;
    public IVariable height;
    private transient int x;
    private transient int y;
    private transient int w;
    private transient int h;
    private transient int level;
    private transient int maxLevel;
    private transient FluidStack fluidStack;

    public void build(int componentX, int componentY, int pageNum) {
        this.x = componentX;
        this.y = componentY;
    }

    public void render(MatrixStack ms, IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
        ms.func_227860_a_();
        Fluid _fluid = this.fluidStack.getFluid();
        FluidAttributes fluidAttributes = _fluid.getAttributes();
        ResourceLocation fluidStill = fluidAttributes.getStillTexture(this.fluidStack);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidStill);
        ResourceLocation spriteLocation = sprite.func_195668_m();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation(spriteLocation.func_110624_b(), "textures/" + spriteLocation.func_110623_a() + ".png"));
        FluidComponent.setGLColorFromInt(fluidAttributes.getColor(this.fluidStack));
        AbstractGui.func_238463_a_((MatrixStack)ms, (int)this.x, (int)((int)((double)(this.y + this.h) - Math.floor((float)this.h * ((float)this.level / (float)this.maxLevel)))), (float)sprite.func_94209_e(), (float)sprite.func_94206_g(), (int)this.w, (int)(this.h * this.level / this.maxLevel), (int)8, (int)8);
        if (context.isAreaHovered(mouseX, mouseY, this.x, this.y, this.w, this.h)) {
            ArrayList<TranslationTextComponent> toolTips = new ArrayList<TranslationTextComponent>();
            toolTips.add(new TranslationTextComponent(fluidAttributes.getTranslationKey(this.fluidStack)));
            TranslationTextComponent liquidAmount = new TranslationTextComponent("for.gui.tooltip.liquid.amount", new Object[]{this.level, this.maxLevel});
            toolTips.add(liquidAmount);
            context.setHoverTooltipComponents(toolTips);
        }
        ms.func_227865_b_();
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        ResourceLocation id = new ResourceLocation(((IVariable)lookup.apply(this.fluid)).asString());
        int mb = ((IVariable)lookup.apply(this.amount)).asNumber().intValue();
        try {
            this.fluidStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(id), mb);
        }
        catch (Exception e) {
            this.fluidStack = FluidStack.EMPTY;
        }
        this.w = ((IVariable)lookup.apply(this.width)).asNumber().intValue();
        this.h = ((IVariable)lookup.apply(this.height)).asNumber().intValue();
        this.level = ((IVariable)lookup.apply(this.amount)).asNumber().intValue();
        this.maxLevel = ((IVariable)lookup.apply(this.max)).asNumber().intValue();
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)1.0f);
    }
}

