/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.core.circuits.ISocketable;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileUtil;
import java.io.IOException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PacketSocketUpdate
extends ForestryPacket
implements IForestryPacketClient {
    private final BlockPos pos;
    private final NonNullList<ItemStack> itemStacks;

    public <T extends TileEntity> PacketSocketUpdate(T tile) {
        this.pos = tile.func_174877_v();
        this.itemStacks = NonNullList.func_191197_a((int)((ISocketable)tile).getSocketCount(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < ((ISocketable)tile).getSocketCount(); ++i) {
            this.itemStacks.set(i, (Object)((ISocketable)tile).getSocket(i));
        }
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.SOCKET_UPDATE;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.func_179255_a(this.pos);
        data.writeItemStacks(this.itemStacks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, PlayerEntity player) throws IOException {
            BlockPos pos = data.func_179259_c();
            NonNullList<ItemStack> itemStacks = data.readItemStacks();
            TileUtil.actOnTile((IWorldReader)player.field_70170_p, pos, ISocketable.class, socketable -> {
                for (int i = 0; i < itemStacks.size(); ++i) {
                    socketable.setSocket(i, (ItemStack)itemStacks.get(i));
                }
            });
        }
    }
}

