/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerServer;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdServer;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.ICustomPacket;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PacketHandlerServer {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ResourceLocation CHANNEL_ID = new ResourceLocation("forestry", "channel");
    public static final String VERSION = "1.0.0";

    public void onPacket(NetworkEvent.ClientCustomPayloadEvent event) {
        PacketBufferForestry data = new PacketBufferForestry((ByteBuf)event.getPayload());
        NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
        ServerPlayerEntity player = ctx.getSender();
        if (player == null) {
            LOGGER.warn("the player was null, event: {}", (Object)event);
            return;
        }
        try {
            byte packetIdOrdinal = data.readByte();
            PacketIdServer packetId = PacketIdServer.VALUES[packetIdOrdinal];
            IForestryPacketHandlerServer packetHandler = packetId.getPacketHandler();
            packetHandler.onPacketData(data, player);
        }
        catch (IOException e) {
            LOGGER.error("exception handling packet", (Throwable)e);
            return;
        }
        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
    }

    public static void sendPacket(IForestryPacketClient packet, ServerPlayerEntity player) {
        Pair<PacketBuffer, Integer> packetData = packet.getPacketData();
        ICustomPacket payload = NetworkDirection.PLAY_TO_CLIENT.buildPacket(packetData, CHANNEL_ID);
        player.field_71135_a.func_147359_a(payload.getThis());
    }
}

