/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.api.climate.IClimateState;
import forestry.core.climate.AbsentClimateState;
import forestry.core.climate.ClimateStateHelper;
import forestry.core.network.IStreamable;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class PacketBufferForestry
extends PacketBuffer {
    public PacketBufferForestry(ByteBuf wrapped) {
        super(wrapped);
    }

    public String func_218666_n() {
        return super.func_150789_c(1024);
    }

    public void writeItemStacks(NonNullList<ItemStack> itemStacks) {
        this.func_150787_b(itemStacks.size());
        for (ItemStack stack : itemStacks) {
            this.func_150788_a(stack);
        }
    }

    public NonNullList<ItemStack> readItemStacks() {
        int stackCount = this.func_150792_a();
        NonNullList itemStacks = NonNullList.func_191196_a();
        for (int i = 0; i < stackCount; ++i) {
            itemStacks.add((Object)this.func_150791_c());
        }
        return itemStacks;
    }

    public void writeInventory(IInventory inventory) {
        int size = inventory.func_70302_i_();
        this.func_150787_b(size);
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            this.func_150788_a(stack);
        }
    }

    public void readInventory(IInventory inventory) {
        int size = this.func_150792_a();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.func_150791_c();
            inventory.func_70299_a(i, stack);
        }
    }

    public void writeFluidStack(FluidStack fluidStack) {
        fluidStack.writeToPacket((PacketBuffer)this);
    }

    public FluidStack readFluidStack() {
        return FluidStack.readFromPacket((PacketBuffer)this);
    }

    public void writeEntityById(Entity entity) {
        this.func_150787_b(entity.func_145782_y());
    }

    @Nullable
    public Entity readEntityById(World world) {
        int entityId = this.func_150792_a();
        return world.func_73045_a(entityId);
    }

    public <T extends Enum<T>> void writeEnum(T enumValue, T[] enumValues) {
        if (enumValues.length <= 256) {
            this.writeByte(enumValue.ordinal());
        } else {
            this.func_150787_b(enumValue.ordinal());
        }
    }

    public <T extends Enum<T>> T readEnum(T[] enumValues) {
        int ordinal = enumValues.length <= 256 ? this.readByte() : this.func_150792_a();
        return enumValues[ordinal];
    }

    public void writeStreamable(@Nullable IStreamable streamable) {
        if (streamable != null) {
            this.writeBoolean(true);
            streamable.writeData(this);
        } else {
            this.writeBoolean(false);
        }
    }

    @Nullable
    public <T extends IStreamable> T readStreamable(IStreamableFactory<T> factory) throws IOException {
        if (this.readBoolean()) {
            return factory.create(this);
        }
        return null;
    }

    public <T extends IStreamable> void writeStreamables(@Nullable List<T> streamables) {
        if (streamables == null) {
            this.func_150787_b(0);
        } else {
            this.func_150787_b(streamables.size());
            for (IStreamable streamable : streamables) {
                this.writeStreamable(streamable);
            }
        }
    }

    public <T extends IStreamable> void readStreamables(List<T> outputList, IStreamableFactory<T> factory) throws IOException {
        outputList.clear();
        int length = this.func_150792_a();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                T streamable = this.readStreamable(factory);
                outputList.add(streamable);
            }
        }
    }

    public void writeClimateState(IClimateState climateState) {
        if (climateState.isPresent()) {
            this.writeBoolean(true);
            this.writeFloat(climateState.getTemperature());
            this.writeFloat(climateState.getHumidity());
            this.writeBoolean(climateState.isMutable());
        } else {
            this.writeBoolean(false);
        }
    }

    public IClimateState readClimateState() {
        if (this.readBoolean()) {
            return ClimateStateHelper.of(this.readFloat(), this.readFloat(), this.readBoolean());
        }
        return AbsentClimateState.INSTANCE;
    }

    public static interface IStreamableFactory<T extends IStreamable> {
        public T create(PacketBufferForestry var1) throws IOException;
    }
}

