/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockLogic;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockRegistry;
import forestry.core.utils.Log;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class MultiblockLogic<T extends IMultiblockControllerInternal>
implements IMultiblockLogic {
    private final Class<T> controllerClass;
    private boolean visited;
    private boolean saveMultiblockData;
    @Nullable
    private CompoundNBT cachedMultiblockData;
    @Nullable
    protected T controller;

    protected MultiblockLogic(Class<T> controllerClass) {
        this.controllerClass = controllerClass;
        this.controller = null;
        this.visited = false;
        this.saveMultiblockData = false;
        this.cachedMultiblockData = null;
    }

    public void setController(@Nullable IMultiblockControllerInternal controller) {
        if (controller == null) {
            this.controller = null;
        } else if (this.controllerClass.isAssignableFrom(controller.getClass())) {
            this.controller = (IMultiblockControllerInternal)this.controllerClass.cast(controller);
        }
    }

    public Class<T> getControllerClass() {
        return this.controllerClass;
    }

    public abstract T getController();

    public abstract T createNewController(World var1);

    @Override
    public void validate(World world, IMultiblockComponent part) {
        MultiblockRegistry.onPartAdded(world, part);
    }

    @Override
    public final void invalidate(World world, IMultiblockComponent part) {
        this.detachSelf(world, part, false);
    }

    @Override
    public final void onChunkUnload(World world, IMultiblockComponent part) {
        this.detachSelf(world, part, true);
    }

    protected void detachSelf(World world, IMultiblockComponent part, boolean chunkUnloading) {
        if (this.controller != null) {
            this.controller.detachBlock(part, chunkUnloading);
            this.controller = null;
        }
        MultiblockRegistry.onPartRemovedFromWorld(world, part);
    }

    @Override
    public void readFromNBT(CompoundNBT data) {
        if (data.func_74764_b("multiblockData")) {
            this.cachedMultiblockData = data.func_74775_l("multiblockData");
        }
    }

    @Override
    public CompoundNBT write(CompoundNBT data) {
        if (this.isMultiblockSaveDelegate() && this.controller != null) {
            CompoundNBT multiblockData = new CompoundNBT();
            this.controller.write(multiblockData);
            data.func_218657_a("multiblockData", (INBT)multiblockData);
        }
        return data;
    }

    public final void assertDetached(IMultiblockComponent part) {
        if (this.controller != null) {
            BlockPos coords = part.getCoordinates();
            Log.info("[assert] Part @ (%d, %d, %d) should be detached already, but detected that it was not. This is not a fatal error, and will be repaired, but is unusual.", coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p());
            this.controller = null;
        }
    }

    @Override
    public final boolean isConnected() {
        return this.controller != null;
    }

    public void becomeMultiblockSaveDelegate() {
        this.saveMultiblockData = true;
    }

    public void forfeitMultiblockSaveDelegate() {
        this.saveMultiblockData = false;
    }

    public final boolean isMultiblockSaveDelegate() {
        return this.saveMultiblockData;
    }

    public final void setUnvisited() {
        this.visited = false;
    }

    public final void setVisited() {
        this.visited = true;
    }

    public final boolean isVisited() {
        return this.visited;
    }

    public final boolean hasMultiblockSaveData() {
        return this.cachedMultiblockData != null;
    }

    @Nullable
    public final CompoundNBT getMultiblockSaveData() {
        return this.cachedMultiblockData;
    }

    public final void onMultiblockDataAssimilated() {
        this.cachedMultiblockData = null;
    }

    @Override
    public void encodeDescriptionPacket(CompoundNBT packetData) {
        if (this.isMultiblockSaveDelegate() && this.controller != null) {
            CompoundNBT tag = new CompoundNBT();
            this.controller.formatDescriptionPacket(tag);
            packetData.func_218657_a("multiblockData", (INBT)tag);
        }
    }

    @Override
    public void decodeDescriptionPacket(CompoundNBT packetData) {
        if (packetData.func_74764_b("multiblockData")) {
            CompoundNBT tag = packetData.func_74775_l("multiblockData");
            if (this.controller != null) {
                this.controller.decodeDescriptionPacket(tag);
            } else {
                this.cachedMultiblockData = tag;
            }
        }
    }
}

