/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.core.features.CoreItems;
import forestry.core.items.definitions.ToolTier;
import forestry.core.utils.ItemStackUtil;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.ToolItem;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class ItemForestryTool
extends ToolItem {
    private final ItemStack remnants;

    public ItemForestryTool(ItemStack remnants, float damageBonus, float speedModifier, Item.Properties properties) {
        super(damageBonus, speedModifier, (IItemTier)ToolTier.BRONZE, CoreItems.BROKEN_BRONZE_PICKAXE.itemEqual(remnants.func_77973_b()) ? PickaxeItem.field_150915_c : ShovelItem.field_150916_c, properties);
        this.remnants = remnants;
    }

    public boolean func_150897_b(BlockState state) {
        if (CoreItems.BRONZE_PICKAXE.itemEqual((Item)this)) {
            int i = this.func_200891_e().func_200925_d();
            if (state.getHarvestTool() == ToolType.PICKAXE) {
                return i >= state.getHarvestLevel();
            }
            Material material = state.func_185904_a();
            return material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g;
        }
        if (CoreItems.BROKEN_BRONZE_SHOVEL.itemEqual((Item)this)) {
            return state.func_203425_a(Blocks.field_150433_aE) || state.func_203425_a(Blocks.field_196604_cC);
        }
        return super.func_150897_b(state);
    }

    public float func_150893_a(ItemStack itemstack, BlockState state) {
        for (ToolType type : this.getToolTypes(itemstack)) {
            if (!state.func_177230_c().isToolEffective(state, type)) continue;
            return this.field_77864_a;
        }
        if (CoreItems.BRONZE_PICKAXE.itemEqual((Item)this)) {
            Material material = state.func_185904_a();
            return material != Material.field_151573_f && material != Material.field_151574_g && material != Material.field_151576_e ? super.func_150893_a(itemstack, state) : this.field_77864_a;
        }
        return super.func_150893_a(itemstack, state);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        Direction facing = context.func_196000_l();
        if (CoreItems.BRONZE_SHOVEL.itemEqual((Item)this)) {
            BlockState state = world.func_180495_p(pos);
            if (facing == Direction.DOWN) {
                return ActionResultType.PASS;
            }
            BlockState modifiedState = state.getToolModifiedState(world, pos, player, context.func_195996_i(), ToolType.SHOVEL);
            BlockState usedState = null;
            if (modifiedState != null && world.func_175623_d(pos.func_177984_a())) {
                world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                usedState = modifiedState;
            } else if (state.func_177230_c() instanceof CampfireBlock && ((Boolean)state.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) {
                if (!world.func_201670_d()) {
                    world.func_217378_a(null, 1009, pos, 0);
                }
                CampfireBlock.func_235475_c_((IWorld)world, (BlockPos)pos, (BlockState)state);
                usedState = (BlockState)state.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.FALSE);
            }
            if (usedState != null) {
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, usedState, 11);
                    if (player != null) {
                        context.func_195996_i().func_222118_a(1, (LivingEntity)player, entity -> this.onBroken((LivingEntity)entity, hand));
                    }
                }
                return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    public void onBroken(LivingEntity player, Hand hand) {
        World world = player.field_70170_p;
        player.func_213334_d(hand);
        if (!world.field_72995_K && !this.remnants.func_190926_b()) {
            ItemStackUtil.dropItemStackAsEntity(this.remnants.func_77946_l(), world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        }
    }

    public void onBroken(LivingEntity player) {
        this.onBroken(player, Hand.MAIN_HAND);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity entity, LivingEntity player) {
        stack.func_222118_a(2, player, this::onBroken);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!world.field_72995_K && state.func_185887_b((IBlockReader)world, pos) != 0.0f) {
            stack.func_222118_a(1, entity, this::onBroken);
        }
        return true;
    }
}

