/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.core.ItemGroupForestry;
import forestry.core.config.Config;
import forestry.core.items.ItemOverlay;
import forestry.core.items.definitions.EnumElectronTube;
import forestry.core.utils.ItemTooltipUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemElectronTube
extends ItemOverlay {
    private final EnumElectronTube type;

    public ItemElectronTube(EnumElectronTube type) {
        super(ItemGroupForestry.tabForestry, type);
        this.type = type;
    }

    public EnumElectronTube getType() {
        return this.type;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemstack, world, list, flag);
        Multimap<ICircuitLayout, ICircuit> circuits = ItemElectronTube.getCircuits(itemstack);
        if (!circuits.isEmpty()) {
            if (Screen.func_231173_s_()) {
                for (ICircuitLayout circuitLayout : circuits.keys()) {
                    String circuitLayoutName = circuitLayout.getUsage();
                    list.add((ITextComponent)new StringTextComponent(circuitLayoutName).func_240701_a_(new TextFormatting[]{TextFormatting.WHITE, TextFormatting.UNDERLINE}));
                    for (ICircuit circuit : circuits.get((Object)circuitLayout)) {
                        circuit.addTooltip(list);
                    }
                }
            } else {
                ItemTooltipUtil.addShiftInformation(itemstack, (IBlockReader)world, list, flag);
            }
        } else {
            list.add((ITextComponent)new StringTextComponent("<").func_230529_a_((ITextComponent)new TranslationTextComponent("for.gui.noeffect").func_240702_b_(">").func_240699_a_(TextFormatting.GRAY)));
        }
    }

    @Override
    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> subItems) {
        ItemStack stack;
        if (this.func_194125_a(tab) && (Config.isDebug || !this.type.isSecret()) && !ItemElectronTube.getCircuits(stack = new ItemStack((IItemProvider)this)).isEmpty()) {
            subItems.add((Object)new ItemStack((IItemProvider)this));
        }
    }

    private static Multimap<ICircuitLayout, ICircuit> getCircuits(ItemStack itemStack) {
        ArrayListMultimap circuits = ArrayListMultimap.create();
        Collection<ICircuitLayout> allLayouts = ChipsetManager.circuitRegistry.getRegisteredLayouts().values();
        for (ICircuitLayout circuitLayout : allLayouts) {
            try {
                ICircuit circuit = ChipsetManager.solderManager.getCircuit(null, circuitLayout, itemStack);
                if (circuit == null) continue;
                circuits.put((Object)circuitLayout, (Object)circuit);
            }
            catch (NullPointerException nullPointerException) {}
        }
        return circuits;
    }
}

