/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import com.google.common.collect.ImmutableSet;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IForestrySpeciesRoot;
import forestry.apiculture.features.ApicultureItems;
import forestry.core.errors.EnumErrorCode;
import forestry.core.inventory.ItemInventory;
import forestry.core.utils.GeneticsUtil;
import forestry.modules.ModuleHelper;
import genetics.api.GeneticHelper;
import genetics.api.individual.IIndividual;
import genetics.api.root.IRootDefinition;
import genetics.utils.RootUtils;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.IWorld;

public class ItemInventoryAlyzer
extends ItemInventory
implements IErrorSource {
    public static final int SLOT_ENERGY = 0;
    public static final int SLOT_SPECIMEN = 1;
    public static final int SLOT_ANALYZE_1 = 2;
    public static final int SLOT_ANALYZE_2 = 3;
    public static final int SLOT_ANALYZE_3 = 4;
    public static final int SLOT_ANALYZE_4 = 5;
    public static final int SLOT_ANALYZE_5 = 6;

    public ItemInventoryAlyzer(PlayerEntity player, ItemStack itemstack) {
        super(player, 7, itemstack);
    }

    public static boolean isAlyzingFuel(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (ModuleHelper.isEnabled("apiculture")) {
            return ApicultureItems.HONEY_DROPS.itemEqual(itemstack) || ApicultureItems.HONEYDEW.itemEqual(itemstack);
        }
        return false;
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 0) {
            return ItemInventoryAlyzer.isAlyzingFuel(itemStack);
        }
        if (this.hasSpecimen() && this.func_70301_a(slotIndex).func_190926_b()) {
            return false;
        }
        IRootDefinition definition = RootUtils.getRoot(itemStack = GeneticsUtil.convertToGeneticEquivalent(itemStack));
        if (!definition.isPresent()) {
            return false;
        }
        IForestrySpeciesRoot speciesRoot = (IForestrySpeciesRoot)definition.get();
        if (slotIndex == 1) {
            return true;
        }
        Optional optionalIndividual = speciesRoot.create(itemStack);
        return optionalIndividual.filter(IIndividual::isAnalyzed).isPresent();
    }

    @Override
    public void func_70299_a(int index, ItemStack itemStack) {
        super.func_70299_a(index, itemStack);
        if (index == 1) {
            this.analyzeSpecimen(itemStack);
        }
    }

    private void analyzeSpecimen(ItemStack specimen) {
        IIndividual individual;
        IRootDefinition definition;
        if (specimen.func_190926_b()) {
            return;
        }
        ItemStack convertedSpecimen = GeneticsUtil.convertToGeneticEquivalent(specimen);
        if (!ItemStack.func_77989_b((ItemStack)specimen, (ItemStack)convertedSpecimen)) {
            this.func_70299_a(1, convertedSpecimen);
            specimen = convertedSpecimen;
        }
        if (!(definition = RootUtils.getRoot(specimen)).isPresent()) {
            return;
        }
        IForestrySpeciesRoot speciesRoot = (IForestrySpeciesRoot)definition.get();
        Optional optionalIndividual = speciesRoot.create(specimen);
        if (optionalIndividual.isPresent() && !(individual = (IIndividual)optionalIndividual.get()).isAnalyzed()) {
            boolean requiresEnergy = ModuleHelper.isEnabled("apiculture");
            if (requiresEnergy && !ItemInventoryAlyzer.isAlyzingFuel(this.func_70301_a(0))) {
                return;
            }
            if (individual.analyze()) {
                IBreedingTracker breedingTracker = speciesRoot.getBreedingTracker((IWorld)this.player.field_70170_p, this.player.func_146103_bH());
                breedingTracker.registerSpecies(individual.getGenome().getPrimary());
                breedingTracker.registerSpecies(individual.getGenome().getSecondary());
                GeneticHelper.setIndividual(specimen, individual);
                if (requiresEnergy) {
                    this.func_70298_a(0, 1);
                }
            }
        }
        this.func_70299_a(2, specimen);
        this.func_70299_a(1, ItemStack.field_190927_a);
    }

    @Override
    public final ImmutableSet<IErrorState> getErrorStates() {
        ImmutableSet.Builder errorStates = ImmutableSet.builder();
        if (!this.hasSpecimen()) {
            errorStates.add((Object)EnumErrorCode.NO_SPECIMEN);
        } else {
            IRootDefinition definition = RootUtils.getRoot(this.getSpecimen());
            if (definition.isPresent() && !ItemInventoryAlyzer.isAlyzingFuel(this.func_70301_a(0))) {
                errorStates.add((Object)EnumErrorCode.NO_HONEY);
            }
        }
        return errorStates.build();
    }

    public ItemStack getSpecimen() {
        for (int i = 1; i <= 6; ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasSpecimen() {
        return !this.getSpecimen().func_190926_b();
    }

    @Override
    protected void onWriteNBT(CompoundNBT nbt) {
        ItemStack energy = this.func_70301_a(0);
        int amount = 0;
        if (!energy.func_190926_b()) {
            amount = energy.func_190916_E();
        }
        nbt.func_74768_a("Charges", amount);
    }
}

