/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements.layouts;

import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.layouts.ContainerElement;
import forestry.core.gui.elements.layouts.FlexLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class LayoutHelper {
    private final List<ContainerElement> elements = new ArrayList<ContainerElement>();
    private final LayoutFactory factory;
    private final int width;
    private final int height;
    private final ContainerElement parent;
    private int xOffset;
    private int yOffset;
    @Nullable
    private ContainerElement current;
    private boolean horizontal;

    public LayoutHelper(LayoutFactory factory, int width, int height, ContainerElement parent) {
        this.factory = factory;
        this.width = width;
        this.height = height;
        this.parent = parent;
    }

    public boolean add(GuiElement element) {
        if (this.current == null) {
            this.current = this.factory.createLayout(0, 0);
            this.elements.add(this.current);
            this.horizontal = this.current.layout instanceof FlexLayout && ((FlexLayout)this.current.layout).isHorizontal();
        }
        Dimension preferredSize = element.getPreferredSize();
        int widgetWidth = Math.max(preferredSize.width, 0);
        int widgetHeight = Math.max(preferredSize.height, 0);
        if (this.horizontal) {
            if (this.xOffset >= this.width) {
                if (this.height != 0 && this.yOffset > this.height) {
                    return false;
                }
                this.yOffset += this.current.getHeight();
                this.current = this.factory.createLayout(0, 0);
                this.elements.add(this.current);
                this.xOffset = 0;
            }
            this.xOffset += widgetWidth;
        } else {
            if (this.yOffset >= this.height) {
                if (this.width != 0 && this.xOffset > this.width) {
                    return false;
                }
                this.xOffset += this.current.getWidth();
                this.current = this.factory.createLayout(0, 0);
                this.elements.add(this.current);
                this.yOffset = 0;
            }
            this.yOffset = widgetHeight;
        }
        this.current.add(element);
        return true;
    }

    public void finish() {
        this.finish(false);
    }

    public void finish(boolean center) {
        for (GuiElement guiElement : this.elements) {
            if (center) {
                guiElement.setAlign(Alignment.TOP_CENTER);
            }
            this.parent.add(guiElement);
        }
        this.clear();
    }

    public void clear() {
        this.elements.clear();
        this.current = null;
        this.xOffset = 0;
        this.yOffset = 0;
    }

    public Collection<ContainerElement> layouts() {
        return this.elements;
    }

    public static interface LayoutFactory {
        public ContainerElement createLayout(int var1, int var2);
    }
}

