/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.IValueElement;
import java.awt.Rectangle;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.StringTextComponent;

public class TextEditElement
extends GuiElement
implements IValueElement<String> {
    @Nullable
    private TextFieldWidget field;
    private int maxLength;
    private Predicate<String> validator;

    public TextEditElement(int maxLength) {
        this(maxLength, null);
    }

    public TextEditElement(int maxLength, @Nullable Predicate<String> validator) {
        this.maxLength = maxLength;
        this.validator = validator;
    }

    public TextEditElement() {
    }

    @Override
    public void setAssignedBounds(Rectangle bounds) {
        super.setAssignedBounds(bounds);
        this.field = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, 0, 0, bounds.width, bounds.height, StringTextComponent.field_240750_d_);
        this.field.func_146185_a(false);
        if (this.maxLength > 0) {
            this.field.func_146203_f(this.maxLength);
        }
    }

    @Override
    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        return this.field != null && this.field.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean onCharTyped(char keyCode, int modifiers) {
        return this.field != null && this.field.func_231042_a_(keyCode, modifiers);
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.field != null && this.field.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public TextEditElement setValidator(Predicate<String> validator) {
        if (this.field == null) {
            return this;
        }
        this.field.func_200675_a(validator);
        return this;
    }

    @Override
    public String getValue() {
        return this.field.func_146179_b();
    }

    @Override
    public void setValue(String value) {
        if (!this.field.func_146179_b().equals(value)) {
            this.field.func_146180_a(value);
        }
    }

    @Override
    public void drawElement(MatrixStack transform, int mouseX, int mouseY) {
        if (this.field == null) {
            return;
        }
        this.field.func_230430_a_(transform, mouseY, mouseX, 0.0f);
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    @Override
    public boolean canMouseOver() {
        return true;
    }
}

