/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import com.google.common.collect.Lists;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.layouts.ContainerElement;
import forestry.core.gui.widgets.IScrollable;
import javax.annotation.Nullable;

public class ScrollableElement
extends ContainerElement
implements IScrollable {
    @Nullable
    private GuiElement content;
    private double scrollPercentage;
    private float step;

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double dWheel) {
        return false;
    }

    public int getInvisibleArea() {
        this.step = 6.0f;
        if (this.content == null) {
            return 0;
        }
        return (int)((this.content.getLayoutSize().getHeight() - this.getLayoutSize().getHeight()) / (double)this.step);
    }

    protected void movePercentage(double percentage) {
        this.scrollPercentage = percentage * (double)this.step;
    }

    @Override
    public void onScroll(int value) {
        this.scrollPercentage = (float)value * this.step;
        if (this.content != null) {
            this.content.setPos(0, -((int)this.scrollPercentage));
        }
    }

    public ScrollableElement addContent(@Nullable GuiElement newContent) {
        if (this.content != null) {
            this.remove(this.content);
            this.content.setCroppedZone(null, 0, 0, -1, -1);
        }
        this.content = newContent;
        if (newContent != null) {
            this.add(newContent);
            newContent.setCroppedZone(this, 0, 0, this.preferredSize.width, this.preferredSize.height);
        }
        return this;
    }

    @Override
    public void clear() {
        this.remove(Lists.newArrayList((Iterable)this.elements));
    }

    @Override
    public boolean canMouseOver() {
        return true;
    }

    @Override
    public boolean isFocused(int mouseX, int mouseY) {
        return this.isMouseOver();
    }
}

